/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.integration;

import com.flipkart.flux.FluxRuntimeRole;
import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.api.Status;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.guice.module.AkkaModule;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.ExecutionContainerModule;
import com.flipkart.flux.guice.module.ExecutionTaskModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.OrchestratorContainerModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.initializer.ExecutionOrderedComponentBooter;
import com.flipkart.flux.initializer.OrchestrationOrderedComponentBooter;
import com.flipkart.flux.integration.SimpleWorkflow;
import com.flipkart.flux.integration.StartEvent;
import com.flipkart.flux.integration.StringEvent;
import com.flipkart.flux.integration.TestCancelPathWorkflow;
import com.flipkart.flux.integration.TestReplayEventTriggerWorkflow;
import com.flipkart.flux.module.DeploymentUnitTestModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.EventsDAO;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAO;
import com.flipkart.flux.persistence.dao.iface.StatesDAO;
import com.flipkart.flux.persistence.dao.impl.ParallelScatterGatherQueryHelper;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.registry.TaskExecutableImpl;
import com.flipkart.flux.registry.TaskExecutableRegistryImpl;
import com.flipkart.flux.rule.DbClearRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, OrchestratorContainerModule.class, FluxClientInterceptorModule.class}, executionModules={FluxClientComponentModule.class, DeploymentUnitTestModule.class, AkkaModule.class, ExecutionTaskModule.class, ExecutionContainerModule.class, ContainerModule.class, FluxClientInterceptorModule.class})
public class E2ETest {
    @Rule
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    public DbClearRule dbClearRule;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    StateMachinesDAO stateMachinesDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    ParallelScatterGatherQueryHelper parallelScatterGatherQueryHelper;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    EventsDAO eventsDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    StatesDAO statesDAO;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    SimpleWorkflow simpleWorkflow;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    OrchestrationOrderedComponentBooter orchestrationOrderedComponentBooter;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    TestCancelPathWorkflow testCancelPathWorkflow;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    TestReplayEventTriggerWorkflow testReplayEventTriggerWorkflow;
    @InjectFromRole(value=FluxRuntimeRole.EXECUTION)
    DeploymentUnitsManager deploymentUnitManager;
    @InjectFromRole(value=FluxRuntimeRole.EXECUTION)
    TaskExecutableRegistryImpl registry;
    @InjectFromRole(value=FluxRuntimeRole.EXECUTION)
    ExecutionOrderedComponentBooter executionOrderedComponentBooter;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    RedriverRegistry redriverRegistry;
    @InjectFromRole(value=FluxRuntimeRole.ORCHESTRATION)
    MessageDao messageDao;

    @Before
    public void setUp() {
        try {
            Unirest.post((String)"http://localhost:9998/api/client-elb/create").queryString("clientId", (Object)"defaultElbId").queryString("clientElbUrl", (Object)"http://localhost:9997").asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() {
        try {
            Unirest.post((String)"http://localhost:9998/api/client-elb/delete").queryString("clientId", (Object)"defaultElbId").asString();
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSimpleWorkflowE2E() throws Exception {
        this.simpleWorkflow.simpleDummyWorkflow(new StringEvent("startingEvent"));
        Thread.sleep(2000L);
        Set smInDb = this.parallelScatterGatherQueryHelper.findStateMachinesByNameAndVersion("com.flipkart.flux.integration.SimpleWorkflow_simpleDummyWorkflow_void_com.flipkart.flux.integration.StringEvent_version1", Long.valueOf(1L));
        String smId = ((StateMachine)smInDb.stream().findFirst().get()).getId();
        Assertions.assertThat((Iterable)smInDb).hasSize(1);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(smId)).hasSize(3);
        Assertions.assertThat((List)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(smId)).hasSize(3);
    }

    @Test
    public void testCancelPathWorkflowE2E() throws Exception {
        this.testCancelPathWorkflow.create(new StartEvent("test_cancel_path"));
        Thread.sleep(6000L);
        Set smInDb = this.parallelScatterGatherQueryHelper.findStateMachinesByNameAndVersion("com.flipkart.flux.integration.TestCancelPathWorkflow_create_void_com.flipkart.flux.integration.StartEvent_version1", Long.valueOf(1L));
        String smId = ((StateMachine)smInDb.stream().findFirst().get()).getId();
        Assertions.assertThat((Iterable)smInDb).hasSize(1);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(smId)).hasSize(9);
        String eventName = "com.flipkart.flux.integration.ParamEvent2";
        Assertions.assertThat((boolean)this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName(smId, eventName, Long.valueOf(0L)).getStatus().toString().equalsIgnoreCase("cancelled"));
        Assertions.assertThat((List)this.eventsDAO.findTriggeredEventsBySMId(smId)).hasSize(3);
        Assertions.assertThat((List)this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(smId)).hasSize(9);
    }

    @Test
    public void testExecConcurrencyValueOfTask() {
        Executable executable = this.registry.getTask("com.flipkart.flux.integration.SimpleWorkflow_simpleStringReturningTask_com.flipkart.flux.integration.StringEvent_com.flipkart.flux.integration.StringEvent_version1");
        Assertions.assertThat((Object)executable).isInstanceOf(TaskExecutableImpl.class);
        TaskExecutableImpl taskExecutable = (TaskExecutableImpl)executable;
        Assertions.assertThat((int)taskExecutable.getExecutionConcurrency()).isEqualTo(5);
    }

    @Test
    public void verifyRedriverPolling() {
        int i;
        this.dbClearRule.explicitClearTables();
        for (i = 0; i < 100; ++i) {
            this.redriverRegistry.registerTask(Long.valueOf((long)i * 1L), "smId", 0L, Long.valueOf(0L));
        }
        for (i = 1; i <= 100; ++i) {
            this.redriverRegistry.registerTask(Long.valueOf(1000L + (long)i), "smId", (long)i * 10000000L, Long.valueOf(0L));
        }
        Long total = this.messageDao.redriverCount();
        try {
            Thread.sleep(12000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((Long)this.messageDao.redriverCount()).isEqualTo(100L);
        this.dbClearRule.explicitClearTables();
    }

    @Test
    public void testReplayEventTriggerWorkflowE2E() throws Exception {
        String smId = "test_replay_event_trigger";
        this.testReplayEventTriggerWorkflow.create(new StartEvent(smId));
        Thread.sleep(2000L);
        StateMachine stateMachine = this.stateMachinesDAO.findById(smId);
        Assertions.assertThat((Long)stateMachine.getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(smId)).hasSize(11);
        Assertions.assertThat((boolean)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE1").isPresent()).isTrue();
        Assertions.assertThat((boolean)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE2").isPresent()).isTrue();
        String replayEventJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data.json"), (String)"UTF-8");
        Unirest.post((String)("http://localhost:9998/api/machines/" + smId + "/context/replayevent")).header("Content-Type", "application/json").body(replayEventJson).asString();
        Thread.sleep(15000L);
        stateMachine = this.stateMachinesDAO.findById(smId);
        Assertions.assertThat((Long)stateMachine.getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(smId)).hasSize(11);
        Assertions.assertThat((String)((Event)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE1").get()).getEventData()).isEqualTo((Object)"42");
        Assertions.assertThat((String)((Event)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE1").get()).getEventSource()).contains(new CharSequence[]{"flux_runtime_replay_internal"});
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.StartEvent0").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent1").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent2").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent3").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent4").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent5").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent6").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent7").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent8").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "RE1").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "RE2").getExecutionVersion()).isEqualTo(0L);
        for (State state : stateMachine.getStates()) {
            switch (state.getName()) {
                case "t1": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t2": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t3": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t4": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t5": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t6": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t7": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t8": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t9": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t10": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                }
            }
        }
        String replayEvent2_Json = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("replay_event_data_2.json"), (String)"UTF-8");
        Unirest.post((String)("http://localhost:9998/api/machines/" + smId + "/context/replayevent")).header("Content-Type", "application/json").body(replayEvent2_Json).asString();
        Thread.sleep(12000L);
        stateMachine = this.stateMachinesDAO.findById(smId);
        Assertions.assertThat((Long)stateMachine.getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((List)this.eventsDAO.findBySMInstanceId(smId)).hasSize(11);
        Assertions.assertThat((String)((Event)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE2").get()).getEventData()).isEqualTo((Object)"50");
        Assertions.assertThat((String)((Event)this.eventsDAO.findValidReplayEventBySMIdAndName(smId, "RE2").get()).getEventSource()).contains(new CharSequence[]{"flux_runtime_replay_internal"});
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.StartEvent0").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent1").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent2").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent3").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent4").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent5").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent6").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent7").getExecutionVersion()).isEqualTo(0L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "com.flipkart.flux.integration.IntegerEvent8").getExecutionVersion()).isEqualTo(2L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "RE1").getExecutionVersion()).isEqualTo(1L);
        Assertions.assertThat((Long)this.eventsDAO.findValidEventBySMIdAndName(smId, "RE2").getExecutionVersion()).isEqualTo(2L);
        for (State state : stateMachine.getStates()) {
            switch (state.getName()) {
                case "t1": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t2": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t3": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t4": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t5": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t6": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t7": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(1L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t8": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(0L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t9": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(2L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                    break;
                }
                case "t10": {
                    Assertions.assertThat((Long)state.getExecutionVersion()).isEqualTo(2L);
                    Assertions.assertThat((String)state.getStatus().toString()).isEqualTo((Object)Status.completed.toString());
                }
            }
        }
    }
}

