/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.persistence.dao.iface.AuditDAO;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import java.util.Iterator;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class AuditDAOTest {
    @InjectFromRole
    AuditDAO auditDAO;
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;

    @Before
    public void setup() {
    }

    @Test
    public void createAuditRecordTest() {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state = null;
        Iterator iterator = stateMachine.getStates().iterator();
        if (iterator.hasNext()) {
            Object ob = iterator.next();
            state = (State)ob;
        }
        AuditRecord auditRecord = new AuditRecord(stateMachine.getId(), state != null ? state.getId() : null, Long.valueOf(0L), Status.completed, null, null, Long.valueOf(0L), null);
        Long recordId = this.auditDAO.create(stateMachine.getId(), auditRecord).getId();
        AuditRecord auditRecord1 = this.auditDAO.findById(stateMachine.getId(), recordId);
        Assertions.assertThat((Object)auditRecord1).isEqualTo((Object)auditRecord);
    }

    @Test
    public void testCreateWithErrorMessageMoreThan1000Chars() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state = null;
        Iterator iterator = stateMachine.getStates().iterator();
        if (iterator.hasNext()) {
            Object ob = iterator.next();
            state = (State)ob;
        }
        String error = RandomStringUtils.randomAlphanumeric((int)1002);
        AuditRecord auditRecord = new AuditRecord(stateMachine.getId(), state != null ? state.getId() : null, Long.valueOf(0L), Status.completed, null, error, Long.valueOf(0L), null);
        Long recordId = this.auditDAO.create(stateMachine.getId(), auditRecord).getId();
        AuditRecord auditRecord1 = this.auditDAO.findById(stateMachine.getId(), recordId);
        Assertions.assertThat((int)auditRecord1.getErrors().length()).isEqualTo(995);
    }

    @Test
    public void testCreateWithErrorMessageLessThan1000Chars() throws Exception {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachine();
        State state = null;
        Iterator iterator = stateMachine.getStates().iterator();
        if (iterator.hasNext()) {
            Object ob = iterator.next();
            state = (State)ob;
        }
        String errorMsg = RandomStringUtils.randomAlphanumeric((int)30);
        AuditRecord auditRecord = new AuditRecord(stateMachine.getId(), state != null ? state.getId() : null, Long.valueOf(0L), Status.completed, null, errorMsg, Long.valueOf(0L), null);
        Long recordId = this.auditDAO.create(stateMachine.getId(), auditRecord).getId();
        AuditRecord auditRecord1 = this.auditDAO.findById(stateMachine.getId(), recordId);
        Assertions.assertThat((String)auditRecord1.getErrors()).isEqualTo((Object)errorMsg);
    }
}

