/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.flux.deploymentunit.iface.ExecutableLoader;
import com.flipkart.flux.registry.TaskExecutableImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.configuration.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutableLoaderImpl
implements ExecutableLoader {
    private static final Logger LOGGER = LogManager.getLogger(ExecutableLoaderImpl.class);
    private final int defaultTaskExecutionConcurrency;

    @Inject
    public ExecutableLoaderImpl(@Named(value="routers.default.instancesPerNode") int instancesPerNode) {
        this.defaultTaskExecutionConcurrency = instancesPerNode;
    }

    @Override
    public Map<String, Executable> loadExecutables(DeploymentUnit deploymentUnit) {
        try {
            DeploymentUnitClassLoader classLoader = deploymentUnit.getDeploymentUnitClassLoader();
            Class<?> taskClass = classLoader.loadClass(Task.class.getCanonicalName());
            Object objectMapperInstance = deploymentUnit.getObjectMapperInstance();
            Object injectorClassInstance = deploymentUnit.getInjectorClassInstance();
            Class<?> injectorClass = injectorClassInstance.getClass();
            Method getInstanceMethod = injectorClass.getMethod("getInstance", Class.class);
            Map<String, Method> taskMethods = deploymentUnit.getTaskMethods();
            Configuration taskConfigs = deploymentUnit.getTaskConfiguration();
            HashMap<String, Executable> registry = new HashMap<String, Executable>();
            for (String taskId : taskMethods.keySet()) {
                Method method = taskMethods.get(taskId);
                Annotation taskAnnotation = method.getAnnotationsByType(taskClass)[0];
                Class<? extends Annotation> annotationType = taskAnnotation.annotationType();
                long timeout = RuntimeConstants.defaultTaskTimeout;
                for (Method annotationMethod : annotationType.getDeclaredMethods()) {
                    Object value = annotationMethod.invoke((Object)taskAnnotation, (Object[])null);
                    if (!annotationMethod.getName().equals("timeout")) continue;
                    timeout = (Long)value;
                }
                MethodId methodId = new MethodId(method);
                Integer taskExecConcurrency = Optional.ofNullable((Integer)taskConfigs.getProperty(methodId.getPrefix() + ".executionConcurrency")).orElse(this.defaultTaskExecutionConcurrency);
                Object singletonMethodOwner = getInstanceMethod.invoke(injectorClassInstance, method.getDeclaringClass());
                registry.put(taskId, (Executable)new TaskExecutableImpl(singletonMethodOwner, method, timeout, taskExecConcurrency.intValue(), (URLClassLoader)classLoader, objectMapperInstance));
            }
            return registry;
        }
        catch (Exception e) {
            LOGGER.error("Unable to populate Executable Registry for deployment unit: {}. Exception: {}", (Object)deploymentUnit.getName(), (Object)e.getMessage());
            throw new FluxError(FluxError.ErrorType.runtime, "Unable to populate Executable Registry for deployment unit: " + deploymentUnit.getName(), (Throwable)e);
        }
    }
}

