/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StateTraversalPathDAOImpl
extends AbstractDAO<StateTraversalPath>
implements StateTraversalPathDAO {
    @Inject
    public StateTraversalPathDAOImpl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public StateTraversalPath create(String stateMachineId, StateTraversalPath stateTraversalPath) {
        return super.save(stateTraversalPath);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Optional<StateTraversalPath> findById(String stateMachineId, Long stateId) {
        Criteria criteria = this.currentSession().createCriteria(StateTraversalPath.class).add((Criterion)Restrictions.eq((String)"stateMachineId", (Object)stateMachineId)).add((Criterion)Restrictions.eq((String)"stateId", (Object)stateId));
        Object object = criteria.uniqueResult();
        StateTraversalPath castedObject = null;
        if (object != null) {
            castedObject = (StateTraversalPath)object;
        }
        return Optional.ofNullable(castedObject);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<StateTraversalPath> findByStateMachineId(String stateMachineId) {
        Criteria criteria = this.currentSession().createCriteria(StateTraversalPath.class).add((Criterion)Restrictions.eq((String)"stateMachineId", (Object)stateMachineId));
        List object = criteria.list();
        List castedObject = object != null ? object : Collections.emptyList();
        return castedObject;
    }
}

