/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.rule;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.rules.ExternalResource;

@Singleton
public class TestReplayableSMRule
extends ExternalResource {
    private final StateMachinesDAO stateMachinesDAO;
    private final EventsDAO eventsDAO;
    private StateMachine stateMachine1;
    private StateMachine stateMachine2;
    private ObjectMapper objectMapper;

    @Inject
    public TestReplayableSMRule(StateMachinesDAO stateMachinesDAO, EventsDAO eventsDAO) {
        this.stateMachinesDAO = stateMachinesDAO;
        this.eventsDAO = eventsDAO;
        this.objectMapper = new ObjectMapper();
    }

    protected void before() throws Throwable {
        StateMachine stateMachine_1 = this.getStateMachine1();
        this.stateMachine1 = this.stateMachinesDAO.create(stateMachine_1.getId(), stateMachine_1);
        StateMachine stateMachine_2 = this.getStateMachine2();
        this.stateMachine2 = this.stateMachinesDAO.create(stateMachine_2.getId(), stateMachine_2);
        this.stateMachine2CreateAllEvents(this.stateMachine2.getId());
    }

    private void stateMachine2CreateAllEvents(String stateMachineId) {
        Event e0 = new Event("e0", "dummyType", Event.EventStatus.triggered, stateMachineId, "e0_Data", "client");
        this.eventsDAO.create(stateMachineId, e0);
        Event e1 = new Event("e1", "dummyType", Event.EventStatus.triggered, stateMachineId, "e1_Data", "managedRuntime");
        this.eventsDAO.create(stateMachineId, e1);
        Event e2 = new Event("e2", "dummyType", Event.EventStatus.triggered, stateMachineId, "e2_Data", "managedRuntime");
        this.eventsDAO.create(stateMachineId, e2);
        Event e3 = new Event("e3", "dummyType", Event.EventStatus.triggered, stateMachineId, "e3_Data", "managedRuntime");
        this.eventsDAO.create(stateMachineId, e3);
        Event e4 = new Event("e4", "dummyType", Event.EventStatus.triggered, stateMachineId, "e4_Data", "managedRuntime");
        this.eventsDAO.create(stateMachineId, e4);
        Event re1 = new Event("re1", "replayEvent", Event.EventStatus.pending, stateMachineId, null, null, Long.valueOf(10L));
        this.eventsDAO.create(stateMachineId, re1);
        Event re2 = new Event("re2", "replayEvent", Event.EventStatus.pending, stateMachineId, null, null);
        this.eventsDAO.create(stateMachineId, re2);
    }

    private StateMachine getStateMachine1() {
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        State state1 = new State(Long.valueOf(2L), "state1", "desc1", onEntryHook, task, onExitHook, null, Long.valueOf(3L), Long.valueOf(60L), "event1", null, null, Long.valueOf(0L), "2", Long.valueOf(1L), Boolean.TRUE);
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("event1");
        State state2 = new State(Long.valueOf(2L), "state2", "desc2", onEntryHook, task, onExitHook, dependencies, Long.valueOf(3L), Long.valueOf(60L), null, null, null, Long.valueOf(0L), "2", Long.valueOf(2L));
        HashSet<State> states = new HashSet<State>();
        states.add(state1);
        states.add(state2);
        StateMachine stateMachine = new StateMachine("2", Long.valueOf(2L), "SM_name", "SM_desc", states, "client_elb_id_1");
        return stateMachine;
    }

    private StateMachine getStateMachine2() throws IOException {
        String onEntryHook = "com.flipkart.flux.dao.DummyOnEntryHook";
        String task = "com.flipkart.flux.dao.TestWorkflow_dummyTask";
        String onExitHook = "com.flipkart.flux.dao.DummyOnExitHook";
        ArrayList<String> deps_t1 = new ArrayList<String>();
        deps_t1.add("e0");
        String oe1 = this.objectMapper.writeValueAsString((Object)new EventDefinition("e1", "dummyType"));
        State t1 = new State(Long.valueOf(2L), "t1", "desc1", onEntryHook, task, onExitHook, deps_t1, Long.valueOf(3L), Long.valueOf(60L), oe1, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(1L), Boolean.FALSE);
        ArrayList<String> deps_t2 = new ArrayList<String>();
        deps_t2.add("e1");
        deps_t2.add("re1");
        String oe2 = this.objectMapper.writeValueAsString((Object)new EventDefinition("e2", "dummyType"));
        State t2 = new State(Long.valueOf(2L), "t2", "desc2", onEntryHook, task, onExitHook, deps_t2, Long.valueOf(3L), Long.valueOf(60L), oe2, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(2L), RuntimeConstants.MAX_REPLAYABLE_RETRIES, Short.valueOf((short)0), Boolean.TRUE, Long.valueOf(0L));
        ArrayList<String> deps_t3 = new ArrayList<String>();
        deps_t3.add("e1");
        deps_t3.add("re2");
        String oe3 = this.objectMapper.writeValueAsString((Object)new EventDefinition("e3", "dummyType"));
        State t3 = new State(Long.valueOf(2L), "t3", "desc2", onEntryHook, task, onExitHook, deps_t3, Long.valueOf(3L), Long.valueOf(60L), oe3, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(3L), RuntimeConstants.MAX_REPLAYABLE_RETRIES, Short.valueOf((short)0), Boolean.TRUE, Long.valueOf(0L));
        ArrayList<String> deps_t4 = new ArrayList<String>();
        deps_t4.add("e2");
        String oe4 = this.objectMapper.writeValueAsString((Object)new EventDefinition("e4", "dummyType"));
        State t4 = new State(Long.valueOf(2L), "t4", "desc1", onEntryHook, task, onExitHook, deps_t4, Long.valueOf(3L), Long.valueOf(60L), oe4, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(4L), Boolean.FALSE);
        ArrayList<String> deps_t5 = new ArrayList<String>();
        deps_t5.add("e3");
        deps_t5.add("e4");
        State t5 = new State(Long.valueOf(2L), "t5", "desc1", onEntryHook, task, onExitHook, deps_t5, Long.valueOf(3L), Long.valueOf(60L), null, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(5L), Boolean.FALSE);
        ArrayList<String> deps_t6 = new ArrayList<String>();
        deps_t6.add("e3");
        State t6 = new State(Long.valueOf(2L), "t6", "desc1", onEntryHook, task, onExitHook, deps_t6, Long.valueOf(3L), Long.valueOf(60L), null, Status.completed, null, Long.valueOf(0L), "id2", Long.valueOf(6L), Boolean.FALSE);
        HashSet<State> states = new HashSet<State>();
        states.add(t1);
        states.add(t2);
        states.add(t3);
        states.add(t4);
        states.add(t5);
        states.add(t6);
        StateMachine stateMachine = new StateMachine("id2", Long.valueOf(2L), "SM_name", "SM_desc", states, "client_elb_id_1");
        return stateMachine;
    }

    public StateMachine getStateMachineWithReplayableState() {
        return this.stateMachine1;
    }

    public StateMachine getStateMachine2WithReplayableState() {
        return this.stateMachine2;
    }
}

