/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.config.TaskRouterUtil;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.resource.DeploymentUnitResource;
import com.flipkart.polyguice.config.YamlConfiguration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentUnitResourceTest {
    DeploymentUnitsManager deploymentUnitsManager = (DeploymentUnitsManager)Mockito.mock(DeploymentUnitsManager.class);
    RouterRegistry routerRegistry = (RouterRegistry)Mockito.mock(RouterRegistry.class);
    int defaultTaskConcurrency = 3;
    DeploymentUnitResource deploymentUnitResource = new DeploymentUnitResource(this.deploymentUnitsManager, this.routerRegistry, new TaskRouterUtil(this.defaultTaskConcurrency));

    @Test
    public void testLoadDeploymentUnit() throws Exception {
        DeploymentUnit unit1 = this.getMockedDUnit("unit1", 1, "task1", this.getMethod1());
        DeploymentUnit unit2 = this.getMockedDUnit("unit2", 1, "task2", this.getMethod2());
        DeploymentUnit unit1_new = this.getMockedDUnit("unit1", 2, "task1", this.getMethod1());
        Mockito.when((Object)this.deploymentUnitsManager.getAllDeploymentUnits()).thenReturn(Arrays.asList(unit1, unit2));
        Mockito.when((Object)this.deploymentUnitsManager.load("unit1", Integer.valueOf(2))).thenReturn((Object)unit1_new);
        Response response = this.deploymentUnitResource.loadDeploymentUnit("unit1", Integer.valueOf(2), Boolean.valueOf(false));
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        ((DeploymentUnitsManager)Mockito.verify((Object)this.deploymentUnitsManager)).load("unit1", Integer.valueOf(2));
        ((RouterRegistry)Mockito.verify((Object)this.routerRegistry)).createOrResize("com.flipkart.flux.resource.DeploymentUnitResourceTest_testMethod", this.defaultTaskConcurrency);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.deploymentUnitsManager});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.routerRegistry});
    }

    @Test
    public void testLoadDeploymentUnitReplace_shouldUnloadPreviousDeploymentUnit() throws Exception {
        DeploymentUnit unit1 = this.getMockedDUnit("unit1", 1, "task1", this.getMethod1());
        DeploymentUnit unit2 = this.getMockedDUnit("unit2", 1, "task2", this.getMethod2());
        DeploymentUnit unit1_new = this.getMockedDUnit("unit1", 2, "task1", this.getMethod1());
        Mockito.when((Object)this.deploymentUnitsManager.getAllDeploymentUnits()).thenReturn(Arrays.asList(unit1, unit2));
        Mockito.when((Object)this.deploymentUnitsManager.load("unit1", Integer.valueOf(2))).thenReturn((Object)unit1_new);
        Response response = this.deploymentUnitResource.loadDeploymentUnit("unit1", Integer.valueOf(2), Boolean.valueOf(true));
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        ((DeploymentUnitsManager)Mockito.verify((Object)this.deploymentUnitsManager)).load("unit1", Integer.valueOf(2));
        ((RouterRegistry)Mockito.verify((Object)this.routerRegistry)).createOrResize("com.flipkart.flux.resource.DeploymentUnitResourceTest_testMethod", 3);
        ((DeploymentUnitsManager)Mockito.verify((Object)this.deploymentUnitsManager)).getAllDeploymentUnits();
        ((DeploymentUnitsManager)Mockito.verify((Object)this.deploymentUnitsManager)).unload("unit1", Integer.valueOf(1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.deploymentUnitsManager});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.routerRegistry});
    }

    @Test
    public void testUnloadDeploymentUnit_shouldCallUnloadAndRemoveUnusedRouter() throws Exception {
        DeploymentUnit unit1 = this.getMockedDUnit("unit1", 1, "task1", this.getMethod1());
        DeploymentUnit unit2 = this.getMockedDUnit("unit2", 1, "task2", this.getMethod2());
        Mockito.when((Object)this.deploymentUnitsManager.getAllDeploymentUnits()).thenReturn(Arrays.asList(unit1, unit2));
        Response response = this.deploymentUnitResource.unloadDeploymentUnit("unit1", Integer.valueOf(1));
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        ((DeploymentUnitsManager)Mockito.verify((Object)this.deploymentUnitsManager)).unload("unit1", Integer.valueOf(1));
        ((RouterRegistry)Mockito.verify((Object)this.routerRegistry)).createOrResize("com.flipkart.flux.resource.DeploymentUnitResourceTest_testMethod", 0);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.routerRegistry});
    }

    private DeploymentUnit getMockedDUnit(String name, Integer version, String taskId, Method m) throws Exception {
        DeploymentUnit unit = (DeploymentUnit)Mockito.mock(DeploymentUnit.class);
        Mockito.when((Object)unit.getName()).thenReturn((Object)name);
        Mockito.when((Object)unit.getVersion()).thenReturn((Object)version);
        Mockito.when((Object)unit.getTaskMethods()).thenReturn(Collections.singletonMap(taskId, m));
        Mockito.when((Object)unit.getTaskConfiguration()).thenReturn((Object)new YamlConfiguration(this.getClass().getClassLoader().getResource("flux_config.yml")));
        return unit;
    }

    private Method getMethod1() throws Exception {
        return this.getClass().getMethod("testMethod", String.class);
    }

    private Method getMethod2() throws Exception {
        return this.getClass().getMethod("testMethod2", String.class);
    }

    @Task(version=1L, timeout=100L)
    public String testMethod(String input) {
        return input;
    }

    @Task(version=1L, timeout=1000L)
    public Integer testMethod2(String input) {
        return input != null ? input.length() : 0;
    }
}

