/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.InjectFromRole;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.module.RuntimeTestModule;
import com.flipkart.flux.rule.DbClearWithTestSMRule;
import com.flipkart.flux.runner.GuiceJunit4Runner;
import com.flipkart.flux.runner.Modules;
import com.flipkart.flux.util.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GuiceJunit4Runner.class)
@Modules(orchestrationModules={FluxClientComponentModule.class, ShardModule.class, RuntimeTestModule.class, ContainerModule.class, OrchestrationTaskModule.class, FluxClientInterceptorModule.class})
public class StateTraversalPathDAOTest {
    @InjectFromRole
    StateTraversalPathDAO stateTraversalPathDAO;
    @InjectFromRole
    @Rule
    public DbClearWithTestSMRule dbClearWithTestSMRule;
    @InjectFromRole
    StateMachinesDAO stateMachinesDAO;

    @Before
    public void setup() {
    }

    @Test
    public void createStateTraversalPathTest() {
        StateMachine stateMachine = this.dbClearWithTestSMRule.getStateMachineWithReplayableState();
        ArrayList<Long> nextDependentStates = new ArrayList<Long>();
        nextDependentStates.add(2L);
        StateTraversalPath stateTraversalPath = new StateTraversalPath(stateMachine.getId(), Long.valueOf(1L), nextDependentStates);
        this.stateTraversalPathDAO.create(stateMachine.getId(), stateTraversalPath);
        Optional stateTraversalPath1 = this.stateTraversalPathDAO.findById(stateMachine.getId(), Long.valueOf(1L));
        Assertions.assertThat(stateTraversalPath1.get()).isEqualTo((Object)stateTraversalPath);
    }

    @Test
    public void testRetrieveByStateMachineId() throws Exception {
        StateMachine standardTestMachine = TestUtils.getStandardTestMachineWithReplayableState();
        this.stateMachinesDAO.create(standardTestMachine.getId(), standardTestMachine);
        ArrayList<Long> nextDependentStates1 = new ArrayList<Long>();
        nextDependentStates1.add(2L);
        nextDependentStates1.add(3L);
        StateTraversalPath stateTraversalPath1 = new StateTraversalPath("standard-machine-replayable", Long.valueOf(1L), nextDependentStates1);
        this.stateTraversalPathDAO.create(standardTestMachine.getId(), stateTraversalPath1);
        ArrayList nextDependentStates4 = new ArrayList();
        nextDependentStates1.add(3L);
        StateTraversalPath stateTraversalPath4 = new StateTraversalPath("standard-machine-replayable", Long.valueOf(4L), nextDependentStates4);
        this.stateTraversalPathDAO.create(standardTestMachine.getId(), stateTraversalPath4);
        Assertions.assertThat((List)this.stateTraversalPathDAO.findByStateMachineId(standardTestMachine.getId())).containsExactly((Object[])new StateTraversalPath[]{stateTraversalPath1, stateTraversalPath4});
    }

    @Test
    public void testRetrieveByStateMachineId_forNoReplayableState() throws Exception {
        Assertions.assertThat((List)this.stateTraversalPathDAO.findByStateMachineId("dummy_state_machine_id")).isEmpty();
    }

    @Test
    public void testRetrieveByStateMachineIdAndStateId_forEmptyStateTraversalPath() throws Exception {
        Optional emptyStateTraversalPath = this.stateTraversalPathDAO.findById("dummy_state_machine_id", Long.valueOf(1L));
        Assertions.assertThat((boolean)emptyStateTraversalPath.isPresent()).isFalse();
    }
}

