/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.cluster.Cluster;
import com.flipkart.flux.FluxRuntimeRole;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.initializer.FluxInitializer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.util.StringUtils;

@Path(value="/status")
@Named
@Singleton
public class StatusResource {
    private AtomicBoolean inRotation = new AtomicBoolean(false);
    private ActorSystemManager actorSystemManager;

    @Inject
    public StatusResource(ActorSystemManager actorSystemManager) {
        this.actorSystemManager = actorSystemManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRotationStatus() {
        boolean rotationStatus = this.inRotation.get();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", rotationStatus ? "up" : "oor");
        int responseCode = (rotationStatus ? Response.Status.OK : Response.Status.NOT_FOUND).getStatusCode();
        return Response.status((int)responseCode).entity(response).build();
    }

    @POST
    @Path(value="/oor")
    public void outOfRotation() {
        this.inRotation.set(false);
    }

    @POST
    @Path(value="/bir")
    public void bringInRotation() {
        this.inRotation.set(true);
    }

    @POST
    @Path(value="/cluster/leave")
    public Response leaveCluster(@QueryParam(value="host") String host, @QueryParam(value="port") Integer port) {
        if (StringUtils.isEmpty((Object)host) || port == null) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"empty hostname or port").build();
        }
        if (FluxInitializer.fluxRole.equals((Object)FluxRuntimeRole.ORCHESTRATION)) {
            return Response.status((int)Response.Status.FORBIDDEN.getStatusCode()).entity((Object)"Api not valid for Flux's orchestraton nodes.").build();
        }
        Address akkAddress = new Address("akka.tcp", this.actorSystemManager.retrieveActorSystem().name(), host, port.intValue());
        Cluster cluster = Cluster.get((ActorSystem)this.actorSystemManager.retrieveActorSystem());
        cluster.leave(akkAddress);
        return Response.status((int)Response.Status.OK.getStatusCode()).build();
    }
}

