/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.codahale.metrics.annotation.Timed;
import com.flipkart.flux.api.ClientElbDefinition;
import com.flipkart.flux.domain.ClientElb;
import com.flipkart.flux.representation.ClientElbPersistenceService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

@Singleton
@Path(value="/api/client-elb")
@Named
public class ClientElbResource {
    private static final Logger logger = LogManager.getLogger(ClientElbResource.class);
    private ClientElbPersistenceService clientElbPersistenceService;

    @Inject
    public ClientElbResource(ClientElbPersistenceService clientElbPersistenceService) {
        this.clientElbPersistenceService = clientElbPersistenceService;
    }

    @POST
    @Path(value="/create")
    @Timed
    @Produces(value={"application/json"})
    public Response createClientElb(@QueryParam(value="clientId") String clientId, @QueryParam(value="clientElbUrl") String clientElbUrl) {
        if (clientElbUrl == null || clientId == null) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"ClientElbUrl or ClientId cannot be null").build();
        }
        try {
            URL verifyingURL = new URL(clientElbUrl);
            verifyingURL.toURI();
            if (verifyingURL.getHost().length() < 1 || verifyingURL.getPath().length() > 0) {
                throw new MalformedURLException();
            }
            ClientElbDefinition clientElbDefinition = new ClientElbDefinition(clientId, clientElbUrl);
            ClientElb clientElb = this.clientElbPersistenceService.persistClientElb(clientElbDefinition.getId(), clientElbDefinition);
            return Response.status((int)Response.Status.CREATED.getStatusCode()).entity((Object)clientElb.getId()).build();
        }
        catch (MalformedURLException ex) {
            logger.error("Malformed URL exception(no path allowed because Elb Url doesn't contain path) {} {} ", (Object)ex.getMessage(), (Object)ex.getStackTrace());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"MalformedURLException").build();
        }
        catch (URISyntaxException ex) {
            logger.error("URI Syntax Exception {} {} ", (Object)ex.getMessage(), (Object)ex.getStackTrace());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"URISyntaxException").build();
        }
        catch (ConstraintViolationException ex) {
            if (ex.getCause() != null && ex.getCause().getMessage().toLowerCase().contains("duplicate entry")) {
                return Response.status((int)Response.Status.CONFLICT.getStatusCode()).entity((Object)ex.getCause().getMessage()).build();
            }
            logger.error("Constraint Violation during creating ClientElb entry with id {} {} {}", (Object)clientId, (Object)ex.getCause().getMessage(), (Object)ex.getStackTrace());
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity(ex.getCause() != null ? ex.getCause().getMessage() : null).build();
        }
        catch (Exception ex) {
            logger.error("Exception occured in ClientElb create {} {} ", (Object)ex.getMessage(), (Object)ex.getStackTrace());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/findById")
    @Timed
    @Produces(value={"application/json"})
    public Response findByIdClientElb(@QueryParam(value="clientId") String clientId) {
        if (clientId == null) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)"ClientId cannot be null").build();
        }
        try {
            String clientElbUrl = this.clientElbPersistenceService.findByIdClientElb(clientId);
            if (clientElbUrl == null) {
                return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)("ClientElb with Id: " + clientId + " not found")).build();
            }
            return Response.status((int)Response.Status.FOUND.getStatusCode()).entity((Object)clientElbUrl).build();
        }
        catch (Exception ex) {
            logger.error("findById failed for input: " + clientId + " {} {} ", (Object)ex.getMessage(), (Object)ex.getStackTrace());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

