/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.ReplayEventException;
import com.flipkart.flux.exception.ReplayableRetryExhaustException;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;

@Singleton
public class ReplayEventPersistenceService {
    private StateMachinesDAO stateMachinesDAO;
    private EventsDAO eventsDAO;
    private StatesDAO statesDAO;
    private AuditDAO auditDAO;
    private SessionFactoryContext sessionFactoryContext;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LogManager.getLogger(ReplayEventPersistenceService.class);

    @Inject
    public ReplayEventPersistenceService(StateMachinesDAO stateMachinesDAO, EventsDAO eventsDAO, StatesDAO statesDAO, AuditDAO auditDAO, @Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        this.stateMachinesDAO = stateMachinesDAO;
        this.eventsDAO = eventsDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.sessionFactoryContext = sessionFactoryContext;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event persistAndProcessReplayEvent(String stateMachineId, EventData replayEventData, List<Long> dependantStateIds, List<String> dependantEvents, State replayableState) throws ReplayEventException, IllegalEventException, ReplayableRetryExhaustException {
        Session session = this.sessionFactoryContext.getThreadLocalSession();
        if (session == null) {
            throw new HibernateException("Unable to initialize hibernate Session");
        }
        short attemptedNumOfReplayableRetries = this.statesDAO.findAttemptedNumOfReplayableRetriesByIdForUpdate_NonTransactional(stateMachineId, replayableState.getId(), session);
        if (attemptedNumOfReplayableRetries >= replayableState.getMaxReplayableRetries()) {
            throw new ReplayableRetryExhaustException("Dependant state:" + replayableState.getName() + " with stateMachineId:" + stateMachineId + " and replay event:" + replayEventData.getName() + " is not replayable as the no of retries have been exhausted.");
        }
        this.statesDAO.updateAttemptedNumOfReplayableRetries_NonTransactional(stateMachineId, replayableState.getId(), (short)(attemptedNumOfReplayableRetries + 1), session);
        Long smExecutionVersion = this.stateMachinesDAO.findExecutionVersionBySMIdForUpdate_NonTransactional(stateMachineId, session) + 1L;
        this.stateMachinesDAO.updateExecutionVersion_NonTransactional(stateMachineId, smExecutionVersion, session);
        ArrayList<Long> stateIds = new ArrayList<Long>(dependantStateIds);
        this.statesDAO.updateStatus_NonTransactional(stateMachineId, stateIds, Status.initialized, session);
        this.statesDAO.updateExecutionVersion_NonTransactional(stateMachineId, stateIds, smExecutionVersion, session);
        for (Long stateId : stateIds) {
            this.auditDAO.create_NonTransactional(new AuditRecord(stateMachineId, stateId, Long.valueOf(0L), Status.initialized, null, null, smExecutionVersion, "Computed at Runtime"), session);
        }
        for (String outputEvent : dependantEvents) {
            String eventType;
            String eventName;
            try {
                eventName = this.getOutputEventName(outputEvent);
                eventType = this.getOutputEventType(outputEvent);
            }
            catch (JsonParseException e) {
                logger.error("Unable to deserialise output event value. Error: {}", (Object)e.getMessage());
                throw new ReplayEventException("Unable to deserialize outputEvent value. Error : " + e.getMessage());
            }
            catch (Exception e) {
                logger.error("Exception. Error: {}", (Object)e.getMessage());
                throw new ReplayEventException("Exception in processing. Error : " + e.getMessage());
            }
            if (eventName == null || eventType == null) {
                logger.error("Json Parsing : Event Name: {} or Event Type: {} cannot be null ", (Object)eventName, (Object)eventType);
                throw new IllegalEventException("Json Parsing : Event Name or Event Type cannot be null");
            }
            this.eventsDAO.markEventAsInvalid_NonTransactional(stateMachineId, eventName, session);
            Event event = new Event(eventName, eventType, Event.EventStatus.pending, stateMachineId, null, null, smExecutionVersion);
            this.eventsDAO.create_NonTransactional(event, session);
        }
        this.eventsDAO.markEventAsInvalid_NonTransactional(stateMachineId, replayEventData.getName(), session);
        String eventSource = !replayEventData.getEventSource().contains("flux_runtime_replay_internal") ? replayEventData.getEventSource().concat(":flux_runtime_replay_internal") : replayEventData.getEventSource();
        Event replayEvent = new Event(replayEventData.getName(), replayEventData.getType(), Event.EventStatus.triggered, stateMachineId, replayEventData.getData(), eventSource, smExecutionVersion);
        return this.eventsDAO.create_NonTransactional(replayEvent, session);
    }

    private String getOutputEventName(String outputEvent) throws JsonParseException, IOException {
        return outputEvent != null ? ((EventDefinition)objectMapper.readValue(outputEvent, EventDefinition.class)).getName() : null;
    }

    private String getOutputEventType(String outputEvent) throws JsonParseException, IOException {
        return outputEvent != null ? ((EventDefinition)objectMapper.readValue(outputEvent, EventDefinition.class)).getType() : null;
    }
}

