/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.initializer;

import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;

@Singleton
public class OrchestrationOrderedComponentBooter
implements Initializable {
    private static final Logger logger = LogManager.getLogger(OrchestrationOrderedComponentBooter.class);
    private final Server apiServer;
    private final Server dashboardServer;

    @Inject
    public OrchestrationOrderedComponentBooter(@Named(value="APIJettyServer") Server apiServer, @Named(value="DashboardJettyServer") Server dashboardServer) {
        this.apiServer = apiServer;
        this.dashboardServer = dashboardServer;
    }

    public void initialize() {
        try {
            logger.info("loading API server");
            this.apiServer.start();
            logger.info("API server started. Say Hello!");
            logger.info("Loading Dashboard Server");
            if (this.dashboardServer.isStopped()) {
                this.dashboardServer.start();
            }
            logger.info("Dashboard server has started. Say Hello!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

