/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.initializer;

import com.flipkart.flux.FluxRuntimeRole;
import com.flipkart.flux.MigrationUtil.MigrationsRunner;
import com.flipkart.flux.client.FluxClientComponentModule;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.guice.module.AkkaModule;
import com.flipkart.flux.guice.module.ConfigModule;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.DeploymentUnitModule;
import com.flipkart.flux.guice.module.ExecutionContainerModule;
import com.flipkart.flux.guice.module.ExecutionTaskModule;
import com.flipkart.flux.guice.module.OrchestrationTaskModule;
import com.flipkart.flux.guice.module.OrchestratorContainerModule;
import com.flipkart.flux.guice.module.ShardModule;
import com.flipkart.flux.initializer.ExecutionOrderedComponentBooter;
import com.flipkart.flux.initializer.OrchestrationOrderedComponentBooter;
import com.flipkart.polyguice.core.support.Polyguice;
import com.google.inject.Module;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluxInitializer {
    private static final Logger logger = LogManager.getLogger(FluxInitializer.class);
    public static FluxRuntimeRole fluxRole;
    private String hostName;
    private static final MessageFormat STARTUP_DISPLAY;
    private Polyguice fluxRuntimeContainer;

    public FluxInitializer() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.fluxRuntimeContainer = new Polyguice();
    }

    public static void main(String[] args) {
        String command = "start";
        if (args.length > 1) {
            command = args[0];
        }
        FluxInitializer fluxInitializer = new FluxInitializer();
        switch (command) {
            case "start": {
                if (args.length == 2) {
                    switch (args[1]) {
                        case "orchestration": {
                            fluxRole = FluxRuntimeRole.ORCHESTRATION;
                            break;
                        }
                        case "execution": {
                            fluxRole = FluxRuntimeRole.EXECUTION;
                        }
                    }
                } else {
                    fluxRole = FluxRuntimeRole.COMBINED;
                }
                fluxInitializer.start();
                break;
            }
            case "migrate": {
                if (args.length < 2) {
                    throw new RuntimeException("<migrate> must be followed with db name");
                }
                if (!args[1].equals("flux") && !args[1].equals("flux_scheduler")) {
                    throw new RuntimeException("<migrate> works only for 'flux' or 'flux_scheduler'");
                }
                fluxRole = FluxRuntimeRole.ORCHESTRATION;
                fluxInitializer.migrate(args[1]);
                break;
            }
            default: {
                throw new RuntimeException("Mandatory program arguments missing either be {start orchestration/execution} or {migrate flux/flux_scheduler}");
            }
        }
    }

    private void loadFluxRuntimeContainer() {
        logger.info("Running as role : {}", (Object)fluxRole);
        ConfigModule configModule = new ConfigModule(fluxRole);
        switch (fluxRole) {
            case ORCHESTRATION: {
                this.fluxRuntimeContainer.modules(new Module[]{configModule, new ContainerModule(), new ShardModule(), new OrchestrationTaskModule(), new OrchestratorContainerModule(), new FluxClientComponentModule()});
                break;
            }
            case EXECUTION: {
                this.fluxRuntimeContainer.modules(new Module[]{configModule, new ContainerModule(), new ExecutionContainerModule(), new DeploymentUnitModule(), new AkkaModule(), new ExecutionTaskModule(), new FluxClientInterceptorModule(), new FluxClientComponentModule()});
                break;
            }
            default: {
                this.fluxRuntimeContainer.modules(new Module[]{configModule, new ContainerModule(), new ShardModule(), new OrchestrationTaskModule(), new OrchestratorContainerModule(), new FluxClientComponentModule(), new ExecutionContainerModule(), new DeploymentUnitModule(), new AkkaModule(), new ExecutionTaskModule(), new FluxClientInterceptorModule()});
            }
        }
        this.fluxRuntimeContainer.scanPackage("com.flipkart.flux");
        this.fluxRuntimeContainer.registerConfigurationProvider(configModule.getConfigProvider());
        this.fluxRuntimeContainer.prepare();
    }

    private void start() {
        logger.info("** Flux starting up... **");
        long start = System.currentTimeMillis();
        this.loadFluxRuntimeContainer();
        switch (fluxRole) {
            case ORCHESTRATION: {
                this.fluxRuntimeContainer.getComponentContext().getInstance(OrchestrationOrderedComponentBooter.class);
                break;
            }
            case EXECUTION: {
                this.fluxRuntimeContainer.getComponentContext().getInstance(ExecutionOrderedComponentBooter.class);
                break;
            }
            default: {
                this.fluxRuntimeContainer.getComponentContext().getInstance(OrchestrationOrderedComponentBooter.class);
                this.fluxRuntimeContainer.getComponentContext().getInstance(ExecutionOrderedComponentBooter.class);
            }
        }
        Object[] displayArgs = new Object[]{System.currentTimeMillis() - start, this.hostName};
        logger.info(STARTUP_DISPLAY.format(displayArgs));
        logger.info("** Flux startup complete **");
    }

    private void migrate(String dbName) {
        this.loadFluxRuntimeContainer();
        MigrationsRunner migrationsRunner = (MigrationsRunner)this.fluxRuntimeContainer.getComponentContext().getInstance(MigrationsRunner.class);
        migrationsRunner.migrate(dbName);
    }

    static {
        STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n Flux             ___          \n          ___    /   \\        \n         /   \\__| ( ) |            Startup Time : {0} ms\n   ___  | ( ) |  \\___/             Host Name: {1} \n  /   \\/ \\___/     \\___         \n | ( ) |   \\___    /   \\   \n  \\___/    /   \\__| ( ) |      \n          | ( ) |  \\___/     \n           \\___/        \n*************************************************************************");
    }
}

