/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.initializer;

import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;

@Singleton
public class ExecutionOrderedComponentBooter
implements Initializable {
    private static final Logger logger = LogManager.getLogger(ExecutionOrderedComponentBooter.class);
    private final Server executionApiServer;
    private final Server executionDashboardServer;
    private final ActorSystemManager actorSystemManager;

    @Inject
    public ExecutionOrderedComponentBooter(RouterRegistry routerRegistry, @Named(value="ExecutionAPIJettyServer") Server executionApiServer, @Named(value="DashboardJettyServer") Server executionDashboardServer, ActorSystemManager actorSystemManager) {
        this.executionApiServer = executionApiServer;
        this.executionDashboardServer = executionDashboardServer;
        this.actorSystemManager = actorSystemManager;
    }

    public void initialize() {
        if (!this.actorSystemManager.isInitialised()) {
            throw new RuntimeException("Actor System should have been initialised by now.");
        }
        try {
            logger.info("loading Execution API server");
            this.executionApiServer.start();
            logger.info("API server started. Say Hello!");
            logger.info("Loading Execution Dashboard Server");
            if (this.executionDashboardServer.isStopped()) {
                this.executionDashboardServer.start();
            }
            logger.info("Execution Dashboard server has started. Say Hello!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

