/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.config.FileLocator;
import com.flipkart.flux.metrics.MetricsClientImpl;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import javax.inject.Named;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class ContainerModule
extends AbstractModule {
    public void configure() {
        this.bind(MetricsClient.class).to(MetricsClientImpl.class).in(Singleton.class);
    }

    @Provides
    public MetricRegistry metricRegistry() {
        return SharedMetricRegistries.getOrCreate((String)"mainMetricRegistry");
    }

    @Named(value="DashboardContext")
    @Provides
    @Singleton
    WebAppContext getDashboardWebAppContext() {
        File[] files;
        String path = null;
        for (File file : files = FileLocator.findDirectories("packaged/webapps/dashboard/WEB-INF", null)) {
            String fileToString = file.toString();
            if (fileToString.contains(".jar!") && fileToString.startsWith("file:/")) {
                if (!(fileToString = fileToString.replace("file:/", "jar:file:/")).contains("runtime-")) continue;
                path = fileToString;
                break;
            }
            if (!fileToString.contains("runtime")) continue;
            path = fileToString;
            break;
        }
        if (path.endsWith("WEB-INF")) {
            path = path.replace("WEB-INF", "");
        }
        WebAppContext webAppContext = new WebAppContext(path, "/admin");
        return webAppContext;
    }

    @Named(value="DashboardJettyServer")
    @Provides
    @Singleton
    Server getDashboardJettyServer(@Named(value="Dashboard.service.port") int port, @Named(value="Dashboard.service.acceptors") int acceptorThreads, @Named(value="Dashboard.service.selectors") int selectorThreads, @Named(value="Dashboard.service.workers") int maxWorkerThreads, @Named(value="DashboardContext") WebAppContext webappContext) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        server.setHandler((Handler)webappContext);
        server.setStopAtShutdown(true);
        return server;
    }

    @Provides
    @Singleton
    ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }
}

