/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class RequestLoggingFilter
implements ContainerRequestFilter {
    private static final Logger logger = LogManager.getLogger(RequestLoggingFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        StringBuilder sb = new StringBuilder();
        sb.append(requestContext.getUriInfo().getPath()).append(" with payload : ").append(this.getRequestPayload(requestContext));
        logger.info("Request : " + sb.toString());
    }

    private String getRequestPayload(ContainerRequestContext requestContext) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = requestContext.getEntityStream();
        StringBuilder payload = new StringBuilder();
        try {
            ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
            byte[] requestEntity = out.toByteArray();
            if (requestEntity.length == 0) {
                payload.append("\n");
            } else {
                payload.append(new String(requestEntity)).append("\n");
            }
            requestContext.setEntityStream((InputStream)new ByteArrayInputStream(requestEntity));
        }
        catch (IOException ex) {
            logger.error("Unable to get payload from the request i/o error. {}", (Object)ex.getMessage());
        }
        return payload.toString();
    }
}

