/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitUtil;
import com.flipkart.polyguice.config.YamlConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryBasedDeploymentUnitUtil
implements DeploymentUnitUtil {
    private static final Logger LOGGER = LogManager.getLogger(DirectoryBasedDeploymentUnitUtil.class);
    private static final String CONFIG_FILE = "flux_config.yml";
    private String deploymentUnitsPath;

    public DirectoryBasedDeploymentUnitUtil(String deploymentUnitsPath) {
        this.deploymentUnitsPath = deploymentUnitsPath;
    }

    @Override
    public List<Path> listAllDirectoryUnits() throws IOException {
        if (this.deploymentUnitsPath != null) {
            return this.getSubDirectories(Paths.get(this.deploymentUnitsPath, new String[0])).map(this::getSubDirectories).flatMap(t -> t).collect(Collectors.toList());
        }
        return new ArrayList<Path>();
    }

    @Override
    public DeploymentUnit getDeploymentUnit(Path path) throws ClassNotFoundException, IOException, NumberFormatException {
        if (!path.isAbsolute()) {
            path = Paths.get(this.deploymentUnitsPath, path.toString());
        }
        int nameCount = path.getNameCount();
        String deploymentUnitName = path.getName(nameCount - 2).toString();
        Integer version = Integer.parseInt(path.getName(nameCount - 1).toString());
        DeploymentUnitClassLoader deploymentUnitClassLoader = ClassLoaderProvider.getClassLoader(path);
        YamlConfiguration configuration = this.getProperties(deploymentUnitClassLoader);
        return new DeploymentUnit(deploymentUnitName, version, deploymentUnitClassLoader, configuration);
    }

    private YamlConfiguration getProperties(DeploymentUnitClassLoader classLoader) throws IOException {
        return new YamlConfiguration(classLoader.getResource(CONFIG_FILE));
    }

    private Stream<Path> getSubDirectories(Path path) {
        try {
            return Files.list(path).filter(e -> Files.isDirectory(e, new LinkOption[0]));
        }
        catch (IOException ioe) {
            return Stream.empty();
        }
    }

    static class ClassLoaderProvider {
        ClassLoaderProvider() {
        }

        public static DeploymentUnitClassLoader getClassLoader(Path path) throws FileNotFoundException {
            Path mainPath = path.resolve("main");
            Path libPath = path.resolve("lib");
            Path configFilePath = path.resolve(DirectoryBasedDeploymentUnitUtil.CONFIG_FILE);
            List mainJars = Collections.EMPTY_LIST;
            try {
                mainJars = Files.list(mainPath).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (mainJars.size() == 0) {
                throw new FileNotFoundException("Unable to build class loader. Required directory " + mainPath + " is empty/not present");
            }
            List libJars = Collections.EMPTY_LIST;
            try {
                libJars = Files.list(libPath).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Files.isRegularFile(configFilePath, new LinkOption[0])) {
                throw new FileNotFoundException("Unable to build class loader. Config file not found");
            }
            URL[] urls = (URL[])Stream.concat(Stream.concat(mainJars.stream(), libJars.stream()), Stream.of(path)).map(e -> {
                try {
                    return e.toUri().toURL();
                }
                catch (MalformedURLException ex) {
                    LOGGER.error("Unexpected malformedURL exception in path.toURL.", (Throwable)ex);
                    return null;
                }
            }).toArray(URL[]::new);
            return new DeploymentUnitClassLoader(urls, null);
        }
    }
}

