/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.Storage;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class EventsDAOImpl
extends AbstractDAO<Event>
implements EventsDAO {
    private static final String TABLE_NAME = "Event";
    private static final String COLUMN_STATE_MACHINE_INSTANCE_ID = "stateMachineInstanceId";
    private static final String COLUMN_STATUS = "status";
    private static final String COLUMN_NAME = "name";

    @Inject
    public EventsDAOImpl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event create(String stateMachineInstanceId, Event event) {
        return super.save(event);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateEvent(String stateMachineInstanceId, Event event) {
        super.update(event);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<Event> findBySMInstanceId(String stateMachineInstanceId) {
        return this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid)).list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event findValidEventBySMIdAndName(String stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<Event> findAllBySMIdAndName(String stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName));
        return criteria.list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event findValidEventsByStateMachineIdAndExecutionVersionAndName(String stateMachineInstanceId, String eventName, Long executionVersion) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid)).add((Criterion)Restrictions.eq((String)"executionVersion", (Object)executionVersion));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<Event> findAllValidEventsByStateMachineIdAndExecutionVersionAndName(String stateMachineInstanceId, List<String> eventNames, Long executionVersion) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add(Restrictions.in((String)COLUMN_NAME, eventNames)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid)).add((Criterion)Restrictions.eq((String)"executionVersion", (Object)executionVersion));
        return criteria.list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<String> findTriggeredOrCancelledEventsNamesBySMId(String stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)COLUMN_STATUS, (Object)Event.EventStatus.triggered), (Criterion)Restrictions.eq((String)COLUMN_STATUS, (Object)Event.EventStatus.cancelled))).setProjection((Projection)Projections.property((String)COLUMN_NAME));
        return criteria.list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<String> findAllValidReplayEventsNamesBySMId(String stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add(Restrictions.ilike((String)"eventSource", (String)"flux_runtime_replay_internal", (MatchMode)MatchMode.ANYWHERE)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid)).setProjection((Projection)Projections.property((String)COLUMN_NAME));
        return criteria.list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Optional<Event> findValidReplayEventBySMIdAndName(String stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName)).add(Restrictions.ilike((String)"eventSource", (String)"flux_runtime_replay_internal", (MatchMode)MatchMode.ANYWHERE)).add((Criterion)Restrictions.ne((String)COLUMN_STATUS, (Object)Event.EventStatus.invalid));
        Object object = criteria.uniqueResult();
        Event castedObject = null;
        if (object != null) {
            castedObject = (Event)object;
        }
        return Optional.ofNullable(castedObject);
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<Event> findTriggeredEventsBySMId(String stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_STATUS, (Object)Event.EventStatus.triggered));
        return criteria.list();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event findTriggeredEventBySMIdAndName(String stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName)).add((Criterion)Restrictions.eq((String)COLUMN_STATUS, (Object)Event.EventStatus.triggered));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public List<VersionedEventData> findByEventNamesAndSMId(String stateMachineInstanceId, List<String> eventNames) {
        if (eventNames.isEmpty()) {
            return new ArrayList<VersionedEventData>();
        }
        StringBuilder eventNamesString = new StringBuilder();
        for (int i = 0; i < eventNames.size(); ++i) {
            eventNamesString.append("'" + eventNames.get(i) + "'");
            if (i == eventNames.size() - 1) continue;
            eventNamesString.append(", ");
        }
        Query hqlQuery = this.currentSession().createQuery("from Event where stateMachineInstanceId = :SMID and status != 'invalid' and name in (" + eventNamesString.toString() + ") order by field(name, " + eventNamesString.toString() + ")").setParameter("SMID", (Object)stateMachineInstanceId);
        List readEvents = hqlQuery.list();
        LinkedList<VersionedEventData> readEventsDTOs = new LinkedList<VersionedEventData>();
        for (Event event : readEvents) {
            readEventsDTOs.add(new VersionedEventData(event.getName(), event.getType(), event.getEventData(), event.getEventSource(), event.getExecutionVersion()));
        }
        return readEventsDTOs;
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Map<String, Event.EventStatus> getAllEventsNameAndStatus(String stateMachineInstanceId, boolean forUpdate) {
        SQLQuery sqlQuery = this.currentSession().createSQLQuery("Select name, status from Events where  status != 'invalid' and stateMachineInstanceId ='" + stateMachineInstanceId + (forUpdate ? "' for update" : "'"));
        List eventRows = sqlQuery.list();
        HashMap<String, Event.EventStatus> eventStatusMap = new HashMap<String, Event.EventStatus>();
        for (Object[] eventRow : eventRows) {
            eventStatusMap.put((String)eventRow[0], Event.EventStatus.valueOf((String)((String)eventRow[1])));
        }
        return eventStatusMap;
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void markEventAsCancelled(String stateMachineInstanceId, String eventName) {
        Query query = this.currentSession().createQuery("update Event set status = :status where status != :invalidStatus and stateMachineInstanceId = :stateMachineInstanceId and name = :eventName");
        query.setString(COLUMN_STATUS, Event.EventStatus.cancelled.toString());
        query.setString("invalidStatus", Event.EventStatus.invalid.toString());
        query.setString(COLUMN_STATE_MACHINE_INSTANCE_ID, stateMachineInstanceId);
        query.setString("eventName", eventName);
        query.executeUpdate();
    }

    @Override
    public Event create_NonTransactional(Event event, Session session) {
        session.save((Object)event);
        return event;
    }

    @Override
    public void markEventAsInvalid_NonTransactional(String stateMachineInstanceId, String eventName, Session session) {
        Query query = session.createQuery("update Event set status = :status where stateMachineInstanceId = :stateMachineInstanceId and name = :eventName");
        query.setString(COLUMN_STATUS, Event.EventStatus.invalid.toString());
        query.setString(COLUMN_STATE_MACHINE_INSTANCE_ID, stateMachineInstanceId);
        query.setString("eventName", eventName);
        query.executeUpdate();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event findBySmIdAndNameAndVersion(String stateMachineInstanceId, String eventName, Long executionVersion) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)COLUMN_STATE_MACHINE_INSTANCE_ID, (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)COLUMN_NAME, (Object)eventName)).add((Criterion)Restrictions.eq((String)"executionVersion", (Object)executionVersion));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void deleteInvalidEvents(String stateMachineInstanceId, List<String> eventNames) {
        if (!eventNames.isEmpty()) {
            StringBuilder eventNamesString = new StringBuilder();
            for (int i = 0; i < eventNames.size(); ++i) {
                eventNamesString.append("'" + eventNames.get(i) + "'");
                if (i == eventNames.size() - 1) continue;
                eventNamesString.append(", ");
            }
            Query query = this.currentSession().createQuery("delete from Event where stateMachineInstanceId = :stateMachineInstanceId and name in (" + eventNamesString.toString() + ") and " + COLUMN_STATUS + " = :status");
            query.setString(COLUMN_STATUS, Event.EventStatus.invalid.toString());
            query.setString(COLUMN_STATE_MACHINE_INSTANCE_ID, stateMachineInstanceId);
            query.executeUpdate();
        }
    }
}

