/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventAndExecutionData;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.VersionedEventData;
import com.flipkart.flux.api.core.TaskExecutionMessage;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StateTraversalPathDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.ReplayEventException;
import com.flipkart.flux.exception.ReplayableRetryExhaustException;
import com.flipkart.flux.exception.TraversalPathException;
import com.flipkart.flux.exception.UnknownStateMachine;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.representation.ClientElbPersistenceService;
import com.flipkart.flux.representation.ReplayEventPersistenceService;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.flipkart.flux.taskDispatcher.ExecutionNodeTaskDispatcher;
import com.flipkart.flux.utils.LoggingUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class WorkFlowExecutionController {
    private static final Logger logger = LogManager.getLogger(WorkFlowExecutionController.class);
    private StateMachinesDAO stateMachinesDAO;
    private EventsDAO eventsDAO;
    private StatesDAO statesDAO;
    private AuditDAO auditDAO;
    private StateTraversalPathDAO stateTraversalPathDAO;
    private ExecutionNodeTaskDispatcher executionNodeTaskDispatcher;
    private RedriverRegistry redriverRegistry;
    private MetricsClient metricsClient;
    private ObjectMapper objectMapper;
    private ClientElbPersistenceService clientElbPersistenceService;
    private ReplayEventPersistenceService replayEventPersistenceService;

    @Inject
    public WorkFlowExecutionController(EventsDAO eventsDAO, StateMachinesDAO stateMachinesDAO, StatesDAO statesDAO, AuditDAO auditDAO, StateTraversalPathDAO stateTraversalPathDAO, ExecutionNodeTaskDispatcher executionNodeTaskDispatcher, RedriverRegistry redriverRegistry, MetricsClient metricsClient, ClientElbPersistenceService clientElbPersistenceService, ReplayEventPersistenceService replayEventPersistenceService) {
        this.eventsDAO = eventsDAO;
        this.stateMachinesDAO = stateMachinesDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.stateTraversalPathDAO = stateTraversalPathDAO;
        this.executionNodeTaskDispatcher = executionNodeTaskDispatcher;
        this.redriverRegistry = redriverRegistry;
        this.metricsClient = metricsClient;
        this.objectMapper = new ObjectMapper();
        this.clientElbPersistenceService = clientElbPersistenceService;
        this.replayEventPersistenceService = replayEventPersistenceService;
    }

    public Set<State> initAndStart(StateMachine stateMachine, Context context) {
        List<String> triggeredEvents = this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(stateMachine.getId());
        Set initialStates = context.getInitialStates(new HashSet<String>(triggeredEvents));
        this.executeStates(stateMachine, initialStates, false);
        return initialStates;
    }

    public void updateTaskStatusAndPostEvent(StateMachine stateMachine, EventAndExecutionData eventAndExecutionData) {
        Event event = this.updateTaskStatusAndPersistEvent(stateMachine, eventAndExecutionData);
        this.processEvent(event, stateMachine.getId());
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    protected Event updateTaskStatusAndPersistEvent(StateMachine stateMachine, EventAndExecutionData eventAndExecutionData) {
        this.updateTaskStatus(stateMachine.getId(), eventAndExecutionData.getExecutionUpdateData().getTaskId(), eventAndExecutionData.getExecutionUpdateData().getTaskExecutionVersion(), eventAndExecutionData.getExecutionUpdateData());
        return this.persistEvent(stateMachine.getId(), eventAndExecutionData.getVersionedEventData());
    }

    public void updateTaskStatusAndHandlePathCancellation(String stateMachineId, EventAndExecutionData eventAndExecutionData) {
        Set<State> executableStates = this.updateTaskStatusAndCancelPath(stateMachineId, eventAndExecutionData);
        logger.info("Path cancellation is done for state machine: {} event: {} which has come from task: {}", (Object)stateMachineId, (Object)eventAndExecutionData.getVersionedEventData().getName(), (Object)eventAndExecutionData.getExecutionUpdateData().getTaskId());
        StateMachine stateMachine = this.stateMachinesDAO.findById(stateMachineId);
        this.executeStates(stateMachine, executableStates, false);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    protected Set<State> updateTaskStatusAndCancelPath(String stateMachineId, EventAndExecutionData eventAndExecutionData) {
        this.updateTaskStatus(stateMachineId, eventAndExecutionData.getExecutionUpdateData().getTaskId(), eventAndExecutionData.getExecutionUpdateData().getTaskExecutionVersion(), eventAndExecutionData.getExecutionUpdateData());
        return this.cancelPath(stateMachineId, eventAndExecutionData.getVersionedEventData());
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    protected Set<State> cancelPath(String stateMachineId, VersionedEventData versionedEventData) {
        HashSet<State> executableStates = new HashSet<State>();
        StateMachine stateMachine = this.stateMachinesDAO.findById(stateMachineId);
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Map<String, Event.EventStatus> eventStatusMap = this.eventsDAO.getAllEventsNameAndStatus(stateMachine.getId(), true);
        LinkedList<String> cancelledEvents = new LinkedList<String>();
        cancelledEvents.add(versionedEventData.getName());
        while (!cancelledEvents.isEmpty()) {
            String eventName = (String)cancelledEvents.poll();
            this.eventsDAO.markEventAsCancelled(stateMachine.getId(), eventName);
            eventStatusMap.put(eventName, Event.EventStatus.cancelled);
            Set dependantStates = context.getDependantStates(eventName);
            for (State state : dependantStates) {
                List dependencies = state.getDependencies();
                boolean allCancelled = true;
                boolean allMet = true;
                for (String dependency : dependencies) {
                    if (eventStatusMap.get(dependency) != Event.EventStatus.cancelled) {
                        allCancelled = false;
                    }
                    if (eventStatusMap.get(dependency) == Event.EventStatus.cancelled || eventStatusMap.get(dependency) == Event.EventStatus.triggered) continue;
                    allMet = false;
                }
                if (allCancelled) {
                    this.statesDAO.updateStatus(state.getStateMachineId(), state.getId(), Status.cancelled);
                    this.auditDAO.create(state.getStateMachineId(), new AuditRecord(stateMachine.getId(), state.getId(), state.getAttemptedNumOfRetries(), Status.cancelled, null, null, state.getExecutionVersion(), "Not applicable"));
                    EventDefinition eventDefinition = null;
                    if (state.getOutputEvent() == null) continue;
                    try {
                        eventDefinition = (EventDefinition)this.objectMapper.readValue(state.getOutputEvent(), EventDefinition.class);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Error occurred while deserializing task outputEvent for stateMachineInstanceId: " + stateMachine.getId() + " taskId: " + state.getId());
                    }
                    cancelledEvents.add(eventDefinition.getName());
                    continue;
                }
                if (!allMet) continue;
                executableStates.add(state);
            }
        }
        return executableStates;
    }

    public void handlePathCancellation(String stateMachineId, VersionedEventData versionedEventData) {
        Set<State> executableStates = this.cancelPath(stateMachineId, versionedEventData);
        logger.info("Path cancellation is done for state machine: {} event: {}", (Object)stateMachineId, (Object)versionedEventData.getName());
        this.executeStates(this.stateMachinesDAO.findById(stateMachineId), executableStates, false);
    }

    public void postReplayEvent(EventData eventData, StateMachine stateMachine) throws IllegalEventException, ReplayableRetryExhaustException, ReplayEventException, IOException {
        Optional<StateTraversalPath> traversalPathStates;
        ArrayList<String> traversalPathEvents;
        Long dependantStateId = this.statesDAO.findStateIdByEventName(stateMachine.getId(), eventData.getName());
        if (dependantStateId == null) {
            throw new IllegalEventException("No dependent state found for the event : " + eventData.getName());
        }
        State dependantStateOnReplayEvent = this.statesDAO.findById(stateMachine.getId(), dependantStateId);
        logger.info("This state {} depends on replay event {}", (Object)dependantStateOnReplayEvent.getName(), (Object)eventData.getName());
        if (dependantStateOnReplayEvent.getReplayable().booleanValue() && (dependantStateOnReplayEvent.getStatus() == Status.completed || dependantStateOnReplayEvent.getStatus() == Status.errored || dependantStateOnReplayEvent.getStatus() == Status.sidelined)) {
            traversalPathEvents = new ArrayList<String>();
            traversalPathStates = this.stateTraversalPathDAO.findById(stateMachine.getId(), dependantStateId);
            if (!traversalPathStates.isPresent()) {
                logger.error("No traversal path found for replayable state id:{} in stateMachineId:{} for event:{}.", (Object)dependantStateId, (Object)stateMachine.getId(), (Object)eventData.getName());
                throw new TraversalPathException("No traversal path found for replayable state id: " + dependantStateId + " and stateMachineId: " + stateMachine.getId());
            }
        } else {
            logger.error("Dependent state: {} with stateMachineId: {} and replayEvent: {} is  not replayable.", (Object)dependantStateOnReplayEvent.getName(), (Object)stateMachine.getId(), (Object)eventData.getName());
            throw new IllegalEventException("Dependant state:" + dependantStateOnReplayEvent.getName() + " with stateMachineId:" + stateMachine.getId() + " and replay event:" + eventData.getName() + " and status: " + dependantStateOnReplayEvent.getStatus() + " is not replayable.");
        }
        List nextDependentStateIds = traversalPathStates.get().getNextDependentStates();
        this.statesDAO.findAllStatesForGivenStateIds(stateMachine.getId(), nextDependentStateIds).forEach(state -> {
            String outputEvent = state.getOutputEvent();
            if (outputEvent != null && !traversalPathEvents.contains(outputEvent)) {
                traversalPathEvents.add(outputEvent);
            }
        });
        logger.info("StateMachineId: {}, Replay event: {}, Replayable state: {}, Traversal path State ids: {} and Traversal path Event names: {}", (Object)stateMachine.getId(), (Object)eventData.getName(), (Object)dependantStateOnReplayEvent.getName(), (Object)nextDependentStateIds, traversalPathEvents);
        this.replayEventPersistenceService.persistAndProcessReplayEvent(stateMachine.getId(), eventData, nextDependentStateIds, traversalPathEvents, dependantStateOnReplayEvent);
        dependantStateOnReplayEvent = this.statesDAO.findById(stateMachine.getId(), dependantStateOnReplayEvent.getId());
        long redriverInterval = 0L;
        this.redriverRegistry.registerTask(dependantStateOnReplayEvent.getId(), dependantStateOnReplayEvent.getStateMachineId(), redriverInterval, dependantStateOnReplayEvent.getExecutionVersion());
    }

    public Set<State> postEvent(VersionedEventData versionedEventData, String stateMachineInstanceId) {
        Event event = this.persistEvent(stateMachineInstanceId, versionedEventData);
        return this.processEvent(event, stateMachineInstanceId);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Event persistEvent(String stateMachineInstanceId, VersionedEventData versionedEventData) {
        Event event = this.eventsDAO.findValidEventsByStateMachineIdAndExecutionVersionAndName(stateMachineInstanceId, versionedEventData.getName(), versionedEventData.getExecutionVersion());
        if (event == null) {
            throw new IllegalEventException("Event with stateMachineId: " + stateMachineInstanceId + ", event name: " + versionedEventData.getName() + " not found");
        }
        event.setStatus(versionedEventData.getCancelled() != null && versionedEventData.getCancelled() != false ? Event.EventStatus.cancelled : Event.EventStatus.triggered);
        event.setEventData(versionedEventData.getData());
        event.setEventSource(versionedEventData.getEventSource());
        this.eventsDAO.updateEvent(event.getStateMachineInstanceId(), event);
        logger.debug("successfully persisted event: {} with execution version: {} for SMId: {}", (Object)versionedEventData.getName(), (Object)versionedEventData.getExecutionVersion(), (Object)stateMachineInstanceId);
        return event;
    }

    public Set<State> processEvent(Event event, String stateMachineInstanceId) {
        StateMachine stateMachine = null;
        stateMachine = this.stateMachinesDAO.findById(stateMachineInstanceId);
        if (stateMachine == null) {
            logger.error("stateMachine with id not found while processing event {} ", (Object)stateMachineInstanceId, (Object)event.getName());
            throw new RuntimeException("StateMachine with id " + stateMachineInstanceId + " not found while processing event " + event.getName());
        }
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Set dependantStates = context.getDependantStates(event.getName());
        logger.debug("These states {} depend on event {}", (Object)dependantStates, (Object)event.getName());
        Set<State> executableStates = this.getExecutableStates(dependantStates, stateMachine.getId());
        logger.debug("These states {} are now unblocked after event {}", executableStates, (Object)event.getName());
        this.executeStates(stateMachine, executableStates, event, false);
        return executableStates;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateTaskStatus(String machineId, Long stateId, Long taskExecutionVersion, ExecutionUpdateData executionUpdateData) {
        Status updateStatus = null;
        switch (executionUpdateData.getStatus()) {
            case initialized: {
                updateStatus = Status.initialized;
                break;
            }
            case running: {
                updateStatus = Status.running;
                break;
            }
            case completed: {
                updateStatus = Status.completed;
                break;
            }
            case cancelled: {
                updateStatus = Status.cancelled;
                break;
            }
            case errored: {
                updateStatus = Status.errored;
                break;
            }
            case sidelined: {
                updateStatus = Status.sidelined;
                break;
            }
            case unsidelined: {
                updateStatus = Status.unsidelined;
            }
        }
        this.metricsClient.markMeter("stateMachine." + executionUpdateData.getStateMachineName() + ".task." + executionUpdateData.getTaskName() + ".status." + updateStatus.name());
        this.updateExecutionStatus(machineId, stateId, taskExecutionVersion, updateStatus, executionUpdateData.getRetrycount(), executionUpdateData.getCurrentRetryCount(), executionUpdateData.getErrorMessage(), executionUpdateData.isDeleteFromRedriver(), executionUpdateData.getDependentAuditEvents());
    }

    public void updateExecutionStatus(String stateMachineId, Long taskId, Long taskExecutionVersion, Status status, long retryCount, long currentRetryCount, String errorMessage, boolean deleteFromRedriver, String dependentAuditEvents) {
        if (taskExecutionVersion.equals(this.statesDAO.findById(stateMachineId, taskId).getExecutionVersion())) {
            this.statesDAO.updateStatus(stateMachineId, taskId, status);
            AuditRecord auditRecord = new AuditRecord(stateMachineId, taskId, Long.valueOf(currentRetryCount), status, null, errorMessage, taskExecutionVersion, dependentAuditEvents);
            this.auditDAO.create(stateMachineId, auditRecord);
            if (deleteFromRedriver) {
                this.redriverRegistry.deRegisterTask(stateMachineId, taskId, taskExecutionVersion);
            }
        } else {
            logger.info("Input taskExecutionVersion: {} is invalid, update task execution status denied for taskId: {}, stateMachineId: {}. Marked to deRegister in redriver.", (Object)taskExecutionVersion, (Object)taskId, (Object)stateMachineId);
            this.redriverRegistry.deRegisterTask(stateMachineId, taskId, taskExecutionVersion);
        }
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void updateEventData(String machineId, VersionedEventData versionedEventData) {
        this.persistEvent(machineId, versionedEventData);
        String eventUpdateAudit = "Event data updated for event: " + versionedEventData.getName();
        this.auditDAO.create(machineId, new AuditRecord(machineId, Long.valueOf(0L), Long.valueOf(0L), null, null, eventUpdateAudit));
        logger.info("Updated event data persisted for event: {} and stateMachineId: {} with execution version: {}", (Object)versionedEventData.getName(), (Object)machineId, (Object)versionedEventData.getExecutionVersion());
    }

    public void unsidelineState(String stateMachineId, Long stateId) throws UnknownStateMachine, IllegalStateException {
        State askedState = null;
        StateMachine stateMachine = this.retrieveStateMachine(stateMachineId);
        if (stateMachine == null) {
            throw new UnknownStateMachine("State machine with id: " + stateMachineId + " not found");
        }
        for (State state : stateMachine.getStates()) {
            if (!Objects.equals(state.getId(), stateId)) continue;
            askedState = state;
            break;
        }
        if (askedState == null) {
            throw new IllegalStateException("State with the asked id: " + stateId + " not found in stateMachine with id: " + stateMachineId);
        }
        HashSet<State> checkExecutableState = new HashSet<State>();
        checkExecutableState.add(askedState);
        if (this.getExecutableStates(checkExecutableState, stateMachineId).isEmpty()) {
            logger.error("Cannot unsideline state: {} with execution version: {}, at least one of the dependent events is in pending status.", (Object)askedState.getName(), (Object)askedState.getExecutionVersion());
            return;
        }
        if (askedState.getStatus() == Status.initialized || askedState.getStatus() == Status.sidelined || askedState.getStatus() == Status.errored || askedState.getStatus() == Status.unsidelined) {
            askedState.setStatus(Status.unsidelined);
            askedState.setAttemptedNumOfRetries(Long.valueOf(0L));
            if (askedState.getReplayable().booleanValue()) {
                askedState.setAttemptedNumOfReplayableRetries((short)0);
            }
            this.statesDAO.updateState(stateMachineId, askedState);
            this.executeStates(stateMachine, Sets.newHashSet(Arrays.asList(askedState)), false);
        }
    }

    public void incrementExecutionRetries(String stateMachineId, Long taskId, Long taskExecutionVersion) {
        if (taskExecutionVersion == this.statesDAO.findById(stateMachineId, taskId).getExecutionVersion()) {
            this.statesDAO.incrementRetryCount(stateMachineId, taskId);
        } else {
            logger.info("Input taskExecutionVersion: {} is invalid, increment execution retries denied for taskId: {}, stateMachineId: {}.", (Object)taskExecutionVersion, (Object)taskId, (Object)stateMachineId);
        }
    }

    private void executeStates(StateMachine stateMachine, Set<State> executableStates, boolean redriverTriggered) {
        this.executeStates(stateMachine, executableStates, null, redriverTriggered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStates(StateMachine stateMachine, Set<State> executableStates, Event currentEvent, boolean redriverTriggered) {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachine.getId().toString());
            executableStates.forEach(state -> {
                if (state.getStatus() != Status.completed && state.getStatus() != Status.cancelled && state.getStatus() != Status.invalid) {
                    List<VersionedEventData> eventDatas = currentEvent != null && state.getDependencies() != null && state.getDependencies().size() == 1 && currentEvent.getName().equals(state.getDependencies().get(0)) ? Collections.singletonList(new VersionedEventData(currentEvent.getName(), currentEvent.getType(), currentEvent.getEventData(), currentEvent.getEventSource(), currentEvent.getExecutionVersion())) : this.eventsDAO.findByEventNamesAndSMId(stateMachine.getId(), state.getDependencies());
                    TaskAndEvents msg = new TaskAndEvents(state.getName(), state.getTask(), state.getId(), state.getExecutionVersion(), eventDatas.toArray(new VersionedEventData[0]), stateMachine.getId(), stateMachine.getName(), state.getOutputEvent(), state.getRetryCount().longValue(), state.getAttemptedNumOfRetries().longValue());
                    if (state.getStatus().equals((Object)Status.initialized) || state.getStatus().equals((Object)Status.unsidelined)) {
                        msg.setFirstTimeExecution(true);
                    }
                    long redriverInterval = redriverTriggered && state.getStatus() == Status.initialized ? (long)(2 * ((int)Math.pow(2.0, 7.0) * 1000)) : 2L * ((long)((int)Math.pow(2.0, state.getRetryCount() + 1L) * 1000) + (state.getRetryCount() + 1L) * state.getTimeout());
                    this.redriverRegistry.registerTask(state.getId(), state.getStateMachineId(), redriverInterval, state.getExecutionVersion());
                    logger.info("Registered the state: {} with execution version: {} for SMId: {} in redriver", (Object)state.getId(), (Object)state.getExecutionVersion(), (Object)state.getStateMachineId());
                    String taskName = state.getTask();
                    String routerName = WorkFlowExecutionController.getRouterName(taskName);
                    TaskExecutionMessage taskExecutionMessage = new TaskExecutionMessage(routerName, msg);
                    String clientElbUrl = this.clientElbPersistenceService.findByIdClientElb(stateMachine.getClientElbId());
                    String endPoint = clientElbUrl + "/api/execution";
                    long startTime = System.currentTimeMillis();
                    int statusCode = this.executionNodeTaskDispatcher.forwardExecutionMessage(endPoint, taskExecutionMessage);
                    long finishTime = System.currentTimeMillis();
                    if (statusCode == 202) {
                        logger.info("Successfully forwarded the taskExecutionMsg for smId:{} taskId:{} and execution version: {} for remoteExecution to host {} took {}ms", (Object)msg.getStateMachineId(), (Object)msg.getTaskId(), (Object)msg.getTaskExecutionVersion(), (Object)endPoint, (Object)(finishTime - startTime));
                    } else {
                        logger.error("Failed to successfully send task for Execution smId:{} taskId:{}, execution version: {} should be retried by Redriver after {} ms.", (Object)msg.getStateMachineId(), (Object)msg.getTaskId(), (Object)msg.getTaskExecutionVersion(), (Object)redriverInterval);
                    }
                } else {
                    logger.info("State machine: {}, Task: {}, Task Execution Version: {} execution request got discarded as the task is {}", (Object)state.getStateMachineId(), (Object)state.getId(), (Object)state.getExecutionVersion(), (Object)state.getStatus());
                }
            });
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    private StateMachine retrieveStateMachine(String stateMachineInstanceId) {
        return this.stateMachinesDAO.findById(stateMachineInstanceId);
    }

    private Set<State> getExecutableStates(Set<State> dependantStates, String stateMachineInstanceId) {
        HashSet<State> executableStates = new HashSet<State>();
        HashSet<String> receivedEvents = new HashSet<String>(this.eventsDAO.findTriggeredOrCancelledEventsNamesBySMId(stateMachineInstanceId));
        HashSet<String> replayEvents = new HashSet<String>(this.eventsDAO.findAllValidReplayEventsNamesBySMId(stateMachineInstanceId));
        receivedEvents.addAll(replayEvents);
        dependantStates.stream().filter(state1 -> state1.isDependencySatisfied(receivedEvents)).forEach(executableStates::add);
        return executableStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redriveTask(String machineId, Long taskId, Long executionVersion) {
        try {
            State state = this.statesDAO.findById(machineId, taskId);
            if (state != null && !state.getExecutionVersion().equals(executionVersion)) {
                logger.info("Redriver: The execution version: {} to redrive is invalid for the state machine: {} with state Id: {} and execution version: {}.", (Object)executionVersion, (Object)machineId, (Object)state.getId(), (Object)state.getExecutionVersion());
                this.redriverRegistry.deRegisterTask(machineId, taskId, executionVersion);
            } else if (state != null && this.isTaskRedrivable(state.getStatus()) && state.getAttemptedNumOfRetries() <= state.getRetryCount()) {
                StateMachine stateMachine = this.retrieveStateMachine(state.getStateMachineId());
                LoggingUtils.registerStateMachineIdForLogging((String)stateMachine.getId().toString());
                logger.info("Redriver: Redriving a task with Id: {} and execution version: {} for state machine: {}", (Object)state.getId(), (Object)executionVersion, (Object)state.getStateMachineId());
                this.executeStates(stateMachine, Collections.singleton(state), true);
            } else {
                this.redriverRegistry.deRegisterTask(machineId, taskId, executionVersion);
            }
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    private boolean isTaskRedrivable(Status taskStatus) {
        return !taskStatus.equals((Object)Status.completed) && !taskStatus.equals((Object)Status.sidelined) && !taskStatus.equals((Object)Status.cancelled);
    }

    public void cancelWorkflow(StateMachine stateMachine) {
        this.stateMachinesDAO.updateStatus(stateMachine.getId(), StateMachineStatus.cancelled);
        stateMachine.getStates().stream().filter(state -> state.getStatus() == Status.initialized || state.getStatus() == Status.errored || state.getStatus() == Status.sidelined).forEach(state -> {
            this.statesDAO.updateStatus(stateMachine.getId(), state.getId(), Status.cancelled);
            this.auditDAO.create(stateMachine.getId(), new AuditRecord(stateMachine.getId(), state.getId(), state.getAttemptedNumOfRetries(), Status.cancelled, null, null));
        });
    }

    public void resetAttemptedNumberOfRetries(String stateMachineId, Long stateId) {
        logger.info("Resetting the replayable retries for stateId: {} in SMId: {}", (Object)stateId, (Object)stateMachineId);
        this.statesDAO.updateReplayableRetries(stateMachineId, stateId, (short)0);
    }

    public void deleteInvalidEvents(String stateMachineId, List<String> eventNames) {
        logger.info("Deleting the events: {} in SMId: {}", eventNames, (Object)stateMachineId);
        this.eventsDAO.deleteInvalidEvents(stateMachineId, eventNames);
    }

    public static String getRouterName(String taskName) {
        int secondUnderscorePosition = taskName.indexOf(95, taskName.indexOf(95) + 1);
        String routerName = taskName.substring(0, secondUnderscorePosition == -1 ? taskName.length() : secondUnderscorePosition);
        return routerName;
    }

    public void persistDiscardedEvent(String machineId, VersionedEventData versionedEventData) {
        Optional<Event> invalidEvent;
        List<Event> allEvents = this.eventsDAO.findAllBySMIdAndName(machineId, versionedEventData.getName());
        if (allEvents.isEmpty()) {
            logger.error("The event: {} for SMId: {} not Found", (Object)versionedEventData.getName(), (Object)machineId);
        }
        if ((invalidEvent = allEvents.stream().filter(event -> event.getExecutionVersion().equals(versionedEventData.getExecutionVersion())).filter(event -> event.getStatus().equals((Object)Event.EventStatus.invalid)).findFirst()).isPresent()) {
            Event updatedEvent = new Event(invalidEvent.get().getName(), invalidEvent.get().getType(), invalidEvent.get().getStatus(), machineId, versionedEventData.getData(), versionedEventData.getEventSource(), invalidEvent.get().getExecutionVersion());
            this.eventsDAO.updateEvent(machineId, updatedEvent);
        } else {
            logger.error("The discarded event: {} for SMId: {} not Found", (Object)versionedEventData.getName(), (Object)machineId);
        }
    }

    public Event getEventData(String smId, String eventName, Long taskExecutionVersion) {
        Event event = this.eventsDAO.findBySmIdAndNameAndVersion(smId, eventName, taskExecutionVersion);
        if (event != null) {
            return event;
        }
        logger.error("Event data not found for smId: {} eventName: {} taskExecutionVersion: {}", (Object)smId, (Object)eventName, (Object)taskExecutionVersion);
        throw new IllegalEventException("Event data not found for smId: " + smId + ", eventName: " + eventName + " and taskExecutionVersion: " + taskExecutionVersion);
    }
}

