/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.config.TaskRouterUtil;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.flipkart.flux.guice.module.AkkaModule;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AkkaModuleTest {
    private AkkaModule akkaModule;
    @Mock
    Configuration configuration;
    @Mock
    DeploymentUnit deploymentUnit;
    @Mock
    DeploymentUnitsManager deploymentUnitManager;

    @Before
    public void setup() {
        this.akkaModule = new AkkaModule();
    }

    @Test
    public void testGetRouterConfigurations_shouldGetConcurrencyValueFromConfigFile() throws Exception {
        Mockito.when((Object)this.configuration.getProperty("com.flipkart.flux.integration.SimpleWorkflow_simpleIntegerReturningTask.executionConcurrency")).thenReturn((Object)5);
        Mockito.when((Object)this.deploymentUnit.getTaskConfiguration()).thenReturn((Object)this.configuration);
        int defaultNoOfActors = 10;
        Class<?> simpleWorkflowClass = this.getClass().getClassLoader().loadClass("com.flipkart.flux.integration.SimpleWorkflow");
        Map<String, Method> taskMethods = Collections.singletonMap("com.flipkart.flux.integration.SimpleWorkflow_simpleIntegerReturningTask_com.flipkart.flux.integration.IntegerEvent_version1", simpleWorkflowClass.getMethod("simpleIntegerReturningTask", new Class[0]));
        Mockito.when((Object)this.deploymentUnit.getTaskMethods()).thenReturn(taskMethods);
        Mockito.when((Object)this.deploymentUnitManager.getAllDeploymentUnits()).thenReturn(Collections.singleton(this.deploymentUnit));
        Assertions.assertThat((Map)this.akkaModule.getRouterConfigs(this.deploymentUnitManager, new TaskRouterUtil(defaultNoOfActors))).containsEntry((Object)"com.flipkart.flux.integration.SimpleWorkflow_simpleIntegerReturningTask", (Object)5);
    }

    @Test
    public void testGetRouterConfigurations_shouldUseDefaultConcurrentValue() throws Exception {
        Mockito.when((Object)this.deploymentUnit.getTaskConfiguration()).thenReturn((Object)this.configuration);
        int defaultNoOfActors = 10;
        Class<?> simpleWorkflowClass = this.getClass().getClassLoader().loadClass("com.flipkart.flux.integration.SimpleWorkflow");
        Map<String, Method> taskMethods = Collections.singletonMap("com.flipkart.flux.integration.SimpleWorkflow_simpleIntegerReturningTask_com.flipkart.flux.integration.IntegerEvent_version1", simpleWorkflowClass.getMethod("simpleIntegerReturningTask", new Class[0]));
        Mockito.when((Object)this.deploymentUnit.getTaskMethods()).thenReturn(taskMethods);
        Mockito.when((Object)this.deploymentUnitManager.getAllDeploymentUnits()).thenReturn(Collections.singleton(this.deploymentUnit));
        Assertions.assertThat((Map)this.akkaModule.getRouterConfigs(this.deploymentUnitManager, new TaskRouterUtil(defaultNoOfActors))).containsEntry((Object)"com.flipkart.flux.integration.SimpleWorkflow_simpleIntegerReturningTask", (Object)defaultNoOfActors);
    }
}

