/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class EventsDAOImpl
extends AbstractDAO<Event>
implements EventsDAO {
    @Inject
    public EventsDAOImpl(@Named(value="fluxSessionFactoryContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    public Event create(Event event) {
        return super.save(event);
    }

    @Override
    @Transactional
    public void updateEvent(Event event) {
        super.update(event);
    }

    @Override
    @Transactional
    public List<Event> findBySMInstanceId(Long stateMachineInstanceId) {
        return this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).list();
    }

    @Override
    @Transactional
    public Event findById(Long id) {
        return (Event)super.findById(Event.class, id);
    }

    @Override
    @Transactional
    public Event findBySMIdAndName(Long stateMachineInstanceId, String eventName) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)"name", (Object)eventName));
        return (Event)criteria.uniqueResult();
    }

    @Override
    @Transactional
    public List<String> findTriggeredOrCancelledEventsNamesBySMId(Long stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"status", (Object)Event.EventStatus.triggered), (Criterion)Restrictions.eq((String)"status", (Object)Event.EventStatus.cancelled))).setProjection((Projection)Projections.property((String)"name"));
        return criteria.list();
    }

    @Override
    @Transactional
    public List<Event> findTriggeredEventsBySMId(Long stateMachineInstanceId) {
        Criteria criteria = this.currentSession().createCriteria(Event.class).add((Criterion)Restrictions.eq((String)"stateMachineInstanceId", (Object)stateMachineInstanceId)).add((Criterion)Restrictions.eq((String)"status", (Object)Event.EventStatus.triggered));
        return criteria.list();
    }

    @Override
    @Transactional
    public List<EventData> findByEventNamesAndSMId(List<String> eventNames, Long stateMachineInstanceId) {
        if (eventNames.isEmpty()) {
            return new ArrayList<EventData>();
        }
        StringBuilder eventNamesString = new StringBuilder();
        for (int i = 0; i < eventNames.size(); ++i) {
            eventNamesString.append("'" + eventNames.get(i) + "'");
            if (i == eventNames.size() - 1) continue;
            eventNamesString.append(", ");
        }
        Query hqlQuery = this.currentSession().createQuery("from Event where stateMachineInstanceId = :SMID and name in (" + eventNamesString.toString() + ") order by field(name, " + eventNamesString.toString() + ")").setParameter("SMID", (Object)stateMachineInstanceId);
        List readEvents = hqlQuery.list();
        LinkedList<EventData> readEventsDTOs = new LinkedList<EventData>();
        for (Event event : readEvents) {
            readEventsDTOs.add(new EventData(event.getName(), event.getType(), event.getEventData(), event.getEventSource()));
        }
        return readEventsDTOs;
    }

    @Override
    @Transactional
    public Map<String, Event.EventStatus> getAllEventsNameAndStatus(Long stateMachineInstanceId, boolean forUpdate) {
        SQLQuery sqlQuery = this.currentSession().createSQLQuery("Select name, status from Events where stateMachineInstanceId = " + stateMachineInstanceId + (forUpdate ? " for update" : ""));
        List eventRows = sqlQuery.list();
        HashMap<String, Event.EventStatus> eventStatusMap = new HashMap<String, Event.EventStatus>();
        for (Object[] eventRow : eventRows) {
            eventStatusMap.put((String)eventRow[0], Event.EventStatus.valueOf((String)((String)eventRow[1])));
        }
        return eventStatusMap;
    }

    @Override
    @Transactional
    public void markEventAsCancelled(Long stateMachineInstanceId, String eventName) {
        Query query = this.currentSession().createQuery("update Event set status = :status where stateMachineInstanceId = :stateMachineInstanceId and name = :eventName");
        query.setString("status", Event.EventStatus.cancelled.toString());
        query.setLong("stateMachineInstanceId", stateMachineInstanceId.longValue());
        query.setString("eventName", eventName);
        query.executeUpdate();
    }
}

