/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.initializer;

import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OrderedComponentBooter
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(OrderedComponentBooter.class);
    private final Server apiServer;
    private final Server dashboardServer;
    private final ActorSystemManager actorSystemManager;
    private final RouterRegistry routerRegistry;

    @Inject
    public OrderedComponentBooter(RouterRegistry routerRegistry, @Named(value="APIJettyServer") Server apiServer, @Named(value="DashboardJettyServer") Server dashboardServer, ActorSystemManager actorSystemManager) {
        this.routerRegistry = routerRegistry;
        this.apiServer = apiServer;
        this.dashboardServer = dashboardServer;
        this.actorSystemManager = actorSystemManager;
    }

    public void initialize() {
        if (!this.actorSystemManager.isInitialised()) {
            throw new RuntimeException("Actor System should have been initialised by now. WTF!!");
        }
        try {
            logger.debug("loading API server");
            this.apiServer.start();
            logger.debug("API server started. Say Hello!");
            logger.debug("Loading Dashboard Server");
            this.dashboardServer.start();
            logger.debug("Dashboard server has started. Say Hello!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

