/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateMachineStatus;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StateMachinesDAOImpl
extends AbstractDAO<StateMachine>
implements StateMachinesDAO {
    @Inject
    public StateMachinesDAOImpl(@Named(value="fluxSessionFactoryContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    public StateMachine create(StateMachine stateMachine) {
        return super.save(stateMachine);
    }

    @Override
    @Transactional
    public StateMachine findById(Long id) {
        return (StateMachine)super.findById(StateMachine.class, id);
    }

    @Override
    @Transactional
    public Set<StateMachine> findByName(String stateMachineName) {
        Criteria criteria = this.currentSession().createCriteria(StateMachine.class).add((Criterion)Restrictions.eq((String)"name", (Object)stateMachineName));
        List stateMachines = criteria.list();
        return new HashSet<StateMachine>(stateMachines);
    }

    @Override
    @Transactional
    public Set<StateMachine> findByNameAndVersion(String stateMachineName, Long version) {
        Criteria criteria = this.currentSession().createCriteria(StateMachine.class).add((Criterion)Restrictions.eq((String)"name", (Object)stateMachineName)).add((Criterion)Restrictions.eq((String)"version", (Object)version));
        List stateMachines = criteria.list();
        return new HashSet<StateMachine>(stateMachines);
    }

    @Override
    @Transactional
    public StateMachine findByCorrelationId(String correlationId) {
        return (StateMachine)this.currentSession().createCriteria(StateMachine.class).add((Criterion)Restrictions.eq((String)"correlationId", (Object)correlationId)).uniqueResult();
    }

    @Override
    @Transactional
    public void updateStatus(Long stateMachineId, StateMachineStatus status) {
        Query query = this.currentSession().createQuery("update StateMachine set status = :status where id = :stateMachineId");
        query.setString("status", status != null ? status.toString() : null);
        query.setLong("stateMachineId", stateMachineId.longValue());
        query.executeUpdate();
    }
}

