/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.controller;

import akka.actor.ActorRef;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.UnknownStateMachine;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Singleton
public class WorkFlowExecutionController {
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowExecutionController.class);
    private StateMachinesDAO stateMachinesDAO;
    private EventsDAO eventsDAO;
    private StatesDAO statesDAO;
    private AuditDAO auditDAO;
    private RouterRegistry routerRegistry;
    private RedriverRegistry redriverRegistry;
    private MetricsClient metricsClient;

    @Inject
    public WorkFlowExecutionController(EventsDAO eventsDAO, StateMachinesDAO stateMachinesDAO, StatesDAO statesDAO, AuditDAO auditDAO, RouterRegistry routerRegistry, RedriverRegistry redriverRegistry, MetricsClient metricsClient) {
        this.eventsDAO = eventsDAO;
        this.stateMachinesDAO = stateMachinesDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.routerRegistry = routerRegistry;
        this.redriverRegistry = redriverRegistry;
        this.metricsClient = metricsClient;
    }

    public Set<State> initAndStart(StateMachine stateMachine) {
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        List<String> triggeredEvents = this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachine.getId());
        Set initialStates = context.getInitialStates(new HashSet<String>(triggeredEvents));
        this.executeStates(stateMachine, initialStates);
        return initialStates;
    }

    public Set<State> postEvent(EventData eventData, Long stateMachineInstanceId, String correlationId) {
        StateMachine stateMachine = null;
        if (stateMachineInstanceId != null) {
            stateMachine = this.retrieveStateMachine(stateMachineInstanceId);
        } else if (correlationId != null) {
            stateMachine = this.retrieveStateMachineByCorrelationId(correlationId);
            Long l = stateMachineInstanceId = stateMachine == null ? null : stateMachine.getId();
        }
        if (stateMachine == null) {
            throw new UnknownStateMachine("State machine with id: " + stateMachineInstanceId + " or correlation id " + correlationId + " not found");
        }
        Event event = this.eventsDAO.findBySMIdAndName(stateMachineInstanceId, eventData.getName());
        if (event == null) {
            throw new IllegalEventException("Event with stateMachineId: " + stateMachineInstanceId + ", event name: " + eventData.getName() + " not found");
        }
        event.setStatus(Event.EventStatus.triggered);
        event.setEventData(eventData.getData());
        event.setEventSource(eventData.getEventSource());
        this.eventsDAO.updateEvent(event);
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        Set dependantStates = context.getDependantStates(eventData.getName());
        logger.debug("These states {} depend on event {}", (Object)dependantStates, (Object)eventData.getName());
        Set<State> executableStates = this.getExecutableStates(dependantStates, stateMachineInstanceId);
        logger.debug("These states {} are now unblocked after event {}", executableStates, (Object)eventData.getName());
        this.executeStates(stateMachine, executableStates, event);
        return executableStates;
    }

    public void updateExecutionStatus(Long stateMachineId, Long taskId, Status status, long retryCount, long currentRetryCount, String errorMessage, boolean deleteFromRedriver) {
        this.statesDAO.updateStatus(taskId, stateMachineId, status);
        this.auditDAO.create(new AuditRecord(stateMachineId, taskId, Long.valueOf(currentRetryCount), status, null, errorMessage));
        if (retryCount > 0L && deleteFromRedriver) {
            this.redriverRegistry.deRegisterTask(taskId);
        }
    }

    public void unsidelineState(Long stateMachineId, Long stateId) {
        State askedState = null;
        StateMachine stateMachine = this.retrieveStateMachine(stateMachineId);
        if (stateMachine == null) {
            throw new UnknownStateMachine("State machine with id: " + stateMachineId + " not found");
        }
        for (State state : stateMachine.getStates()) {
            if (!Objects.equals(state.getId(), stateId)) continue;
            askedState = state;
            break;
        }
        if (askedState == null) {
            throw new IllegalStateException("State with the asked id: " + stateId + " not found in stateMachine with id: " + stateMachineId);
        }
        if (askedState.getStatus() == Status.sidelined || askedState.getStatus() == Status.errored) {
            askedState.setStatus(Status.unsidelined);
            askedState.setAttemptedNoOfRetries(Long.valueOf(0L));
            this.statesDAO.updateState(askedState);
            this.executeStates(stateMachine, Sets.newHashSet(Arrays.asList(askedState)));
        }
    }

    public void incrementExecutionRetries(Long stateMachineId, Long taskId) {
        this.statesDAO.incrementRetryCount(taskId, stateMachineId);
    }

    private StateMachine retrieveStateMachineByCorrelationId(String correlationId) {
        return this.stateMachinesDAO.findByCorrelationId(correlationId);
    }

    private void executeStates(StateMachine stateMachine, Set<State> executableStates) {
        this.executeStates(stateMachine, executableStates, null);
    }

    private void executeStates(StateMachine stateMachine, Set<State> executableStates, Event currentEvent) {
        MDC.put((String)"stateMachineId", (String)stateMachine.getId().toString());
        executableStates.forEach(state -> {
            MDC.put((String)"taskId", (String)state.getId().toString());
            if (state.getStatus() != Status.completed) {
                int secondUnderscorePosition;
                String taskName;
                List<EventData> eventDatas = currentEvent != null && state.getDependencies() != null && state.getDependencies().size() == 1 && currentEvent.getName().equals(state.getDependencies().get(0)) ? Collections.singletonList(new EventData(currentEvent.getName(), currentEvent.getType(), currentEvent.getEventData(), currentEvent.getEventSource())) : this.eventsDAO.findByEventNamesAndSMId(state.getDependencies(), stateMachine.getId());
                TaskAndEvents msg = new TaskAndEvents(state.getName(), state.getTask(), state.getId(), eventDatas.toArray(new EventData[0]), stateMachine.getId(), stateMachine.getName(), state.getOutputEvent(), state.getRetryCount().longValue(), state.getAttemptedNoOfRetries().longValue());
                if (state.getStatus().equals((Object)Status.initialized) || state.getStatus().equals((Object)Status.unsidelined)) {
                    msg.setFirstTimeExecution(true);
                }
                if (state.getRetryCount() > 0L) {
                    long redriverInterval = 2L * ((long)((int)Math.pow(2.0, state.getRetryCount() + 1L) * 1000) + (state.getRetryCount() + 1L) * state.getTimeout());
                    this.redriverRegistry.registerTask(state.getId(), redriverInterval);
                }
                String routerName = taskName.substring(0, (secondUnderscorePosition = (taskName = state.getTask()).indexOf(95, taskName.indexOf(95) + 1)) == -1 ? taskName.length() : secondUnderscorePosition);
                ActorRef router = this.routerRegistry.getRouter(routerName);
                router.tell((Object)msg, ActorRef.noSender());
                this.metricsClient.incCounter("stateMachine." + msg.getStateMachineName() + ".task." + msg.getTaskName() + ".queueSize");
                logger.info("Sending msg to router: {} to execute state machine: {} task: {}", new Object[]{router.path(), stateMachine.getId(), msg.getTaskId()});
            } else {
                logger.info("State machine: {} Task: {} execution request got discarded as the task is already completed", (Object)state.getStateMachineId(), (Object)state.getId());
            }
        });
    }

    private StateMachine retrieveStateMachine(Long stateMachineInstanceId) {
        return this.stateMachinesDAO.findById(stateMachineInstanceId);
    }

    private Set<State> getExecutableStates(Set<State> dependantStates, Long stateMachineInstanceId) {
        HashSet<State> executableStates = new HashSet<State>();
        HashSet<String> receivedEvents = new HashSet<String>(this.eventsDAO.findTriggeredEventsNamesBySMId(stateMachineInstanceId));
        dependantStates.stream().filter(state1 -> state1.isDependencySatisfied(receivedEvents)).forEach(executableStates::add);
        return executableStates;
    }

    public void redriveTask(Long taskId) {
        MDC.put((String)"taskId", (String)taskId.toString());
        State state = this.statesDAO.findById(taskId);
        if (state != null && this.isTaskRedrivable(state.getStatus()) && state.getAttemptedNoOfRetries() < state.getRetryCount()) {
            StateMachine stateMachine = this.retrieveStateMachine(state.getStateMachineId());
            MDC.put((String)"stateMachineId", (String)stateMachine.getId().toString());
            logger.info("Redriving a task with Id: {} for state machine: {}", (Object)state.getId(), (Object)state.getStateMachineId());
            this.executeStates(stateMachine, Collections.singleton(state));
        } else {
            this.redriverRegistry.deRegisterTask(taskId);
        }
    }

    private boolean isTaskRedrivable(Status taskStatus) {
        return !taskStatus.equals((Object)Status.completed) && !taskStatus.equals((Object)Status.sidelined) && !taskStatus.equals((Object)Status.cancelled);
    }
}

