/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.config;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;

@Singleton
public class TaskRouterUtil {
    private int defaultNoOfActors;

    @Inject
    public TaskRouterUtil(@Named(value="routers.default.instancesPerNode") int defaultNoOfActors) {
        this.defaultNoOfActors = defaultNoOfActors;
    }

    public String getRouterName(Method method) {
        return new MethodId(method).getPrefix();
    }

    public Set<String> getRouterNames(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getTaskMethods().values().stream().map(m -> this.getRouterName((Method)m)).collect(Collectors.toSet());
    }

    public Integer getConcurrency(DeploymentUnit deploymentUnit, String routerName) {
        return Optional.ofNullable((Integer)deploymentUnit.getTaskConfiguration().getProperty(routerName + ".executionConcurrency")).orElse(this.defaultNoOfActors);
    }
}

