/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.config.TaskRouterUtil;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;

public class AkkaModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="routerConfigMap")
    public Map<String, Integer> getRouterConfigs(DeploymentUnitsManager deploymentUnitsManager, TaskRouterUtil taskRouterUtil) {
        ConcurrentHashMap<String, Integer> routerConfigMap = new ConcurrentHashMap<String, Integer>();
        for (DeploymentUnit deploymentUnit : deploymentUnitsManager.getAllDeploymentUnits()) {
            Map<String, Method> taskMethods = deploymentUnit.getTaskMethods();
            for (Method taskMethod : taskMethods.values()) {
                String routerName = taskRouterUtil.getRouterName(taskMethod);
                Integer taskExecConcurrency = taskRouterUtil.getConcurrency(deploymentUnit, routerName);
                routerConfigMap.put(routerName, taskExecConcurrency);
            }
        }
        return routerConfigMap;
    }
}

