/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.resource.FsmGraphEdge;
import com.flipkart.flux.resource.FsmGraphVertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FsmGraph {
    @JsonProperty
    private Map<FsmGraphVertex, FsmGraphEdge> fsmGraphData = new HashMap<FsmGraphVertex, FsmGraphEdge>();
    @JsonProperty
    private Set<FsmGraphEdge> initStateEdges = new HashSet<FsmGraphEdge>();
    @JsonProperty
    private List<AuditRecord> auditData;
    @JsonProperty
    private Long stateMachineId;
    @JsonProperty
    private String correlationId;
    @JsonProperty
    private Long fsmVersion;
    @JsonProperty
    private String fsmName;

    @JsonIgnore
    public void addVertex(FsmGraphVertex vertex, FsmGraphEdge fsmGraphEdge) {
        if (!this.fsmGraphData.containsKey(vertex)) {
            this.fsmGraphData.put(vertex, fsmGraphEdge);
        }
    }

    @JsonIgnore
    public void addOutgoingEdge(FsmGraphVertex from, Long to) {
        this.fsmGraphData.get(from).addOutgoingVertex(to);
    }

    @JsonIgnore
    public void addInitStateEdge(FsmGraphEdge edge) {
        this.initStateEdges.add(edge);
    }

    public void setAuditData(List<AuditRecord> auditData) {
        this.auditData = auditData;
    }

    public void setStateMachineId(Long stateMachineId) {
        this.stateMachineId = stateMachineId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setFsmVersion(Long fsmVersion) {
        this.fsmVersion = fsmVersion;
    }

    public void setFsmName(String fsmName) {
        this.fsmName = fsmName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FsmGraph fsmGraph = (FsmGraph)o;
        return !(this.fsmGraphData == null ? fsmGraph.fsmGraphData != null : !this.fsmGraphData.equals(fsmGraph.fsmGraphData));
    }

    public int hashCode() {
        return this.fsmGraphData != null ? this.fsmGraphData.hashCode() : 0;
    }

    public String toString() {
        return "FsmGraph{fsmGraphData=" + this.fsmGraphData + '}';
    }
}

