/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.model.Task;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.constant.RuntimeConstants;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.DeploymentUnitClassLoader;
import com.flipkart.flux.guice.annotation.ManagedEnv;
import com.flipkart.flux.registry.TaskExecutableImpl;
import com.flipkart.polyguice.core.Initializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutableRegistryPopulator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutableRegistryPopulator.class);
    private final int defaultTaskExecutionConcurrency;
    private ExecutableRegistry executableRegistry;
    private Map<String, DeploymentUnit> deploymentUnitsMap;

    @Inject
    public ExecutableRegistryPopulator(@ManagedEnv ExecutableRegistry executableRegistry, @Named(value="deploymentUnits") Map<String, DeploymentUnit> deploymentUnitsMap, @Named(value="routers.default.instancesPerNode") int defaultNoOfActors) {
        this.executableRegistry = executableRegistry;
        this.deploymentUnitsMap = deploymentUnitsMap;
        this.defaultTaskExecutionConcurrency = defaultNoOfActors;
    }

    public void initialize() {
        CountDownLatch duCountDownLatch = new CountDownLatch(this.deploymentUnitsMap.size());
        for (Map.Entry<String, DeploymentUnit> deploymentUnitEntry : this.deploymentUnitsMap.entrySet()) {
            new Thread(new ExecutableRegistryLoader(deploymentUnitEntry.getKey(), deploymentUnitEntry.getValue(), duCountDownLatch)).start();
        }
        try {
            duCountDownLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("Unable to populate executable registry. Deployment unit count down latch has been interrupted. Exception: {}", (Object)e.getMessage());
            throw new FluxError(FluxError.ErrorType.runtime, "Unable to populate executable registry. Deployment unit count down latch has been interrupted.", (Throwable)e);
        }
    }

    private class ExecutableRegistryLoader
    implements Runnable {
        private String deploymentUnitName;
        private DeploymentUnit deploymentUnit;
        private CountDownLatch duCountDownLatch;

        ExecutableRegistryLoader(String deploymentUnitName, DeploymentUnit deploymentUnit, CountDownLatch duCountDownLatch) {
            this.deploymentUnitName = deploymentUnitName;
            this.deploymentUnit = deploymentUnit;
            this.duCountDownLatch = duCountDownLatch;
        }

        @Override
        public void run() {
            try {
                DeploymentUnitClassLoader classLoader = this.deploymentUnit.getDeploymentUnitClassLoader();
                Class<?> taskClass = classLoader.loadClass(Task.class.getCanonicalName());
                Object objectMapperInstance = this.deploymentUnit.getObjectMapperInstance();
                Object injectorClassInstance = this.deploymentUnit.getInjectorClassInstance();
                Class<?> injectorClass = injectorClassInstance.getClass();
                Method getInstanceMethod = injectorClass.getMethod("getInstance", Class.class);
                Set<Method> taskMethods = this.deploymentUnit.getTaskMethods();
                Configuration taskConfigs = this.deploymentUnit.getTaskConfiguration();
                for (Method method : taskMethods) {
                    Annotation taskAnnotation = method.getAnnotationsByType(taskClass)[0];
                    Class<? extends Annotation> annotationType = taskAnnotation.annotationType();
                    long timeout = RuntimeConstants.defaultTaskTimeout;
                    long version = 0L;
                    for (Method annotationMethod : annotationType.getDeclaredMethods()) {
                        Object value = annotationMethod.invoke((Object)taskAnnotation, (Object[])null);
                        if (annotationMethod.getName().equals("timeout")) {
                            timeout = (Long)value;
                        }
                        if (!annotationMethod.getName().equals("version")) continue;
                        version = (Long)value;
                    }
                    MethodId methodId = new MethodId(method);
                    String taskIdentifier = methodId.toString() + "_version" + version;
                    Integer taskExecConcurrency = Optional.ofNullable((Integer)taskConfigs.getProperty(methodId.getPrefix() + ".executionConcurrency")).orElse(ExecutableRegistryPopulator.this.defaultTaskExecutionConcurrency);
                    Object singletonMethodOwner = getInstanceMethod.invoke(injectorClassInstance, method.getDeclaringClass());
                    ExecutableRegistryPopulator.this.executableRegistry.registerTask(taskIdentifier, (Executable)new TaskExecutableImpl(singletonMethodOwner, method, timeout, taskExecConcurrency.intValue(), (URLClassLoader)classLoader, objectMapperInstance));
                }
                this.duCountDownLatch.countDown();
            }
            catch (Exception e) {
                LOGGER.error("Unable to populate Executable Registry for deployment unit: {}. Exception: {}", (Object)this.deploymentUnitName, (Object)e.getMessage());
                throw new FluxError(FluxError.ErrorType.runtime, "Unable to populate Executable Registry for deployment unit: " + this.deploymentUnitName, (Throwable)e);
            }
        }
    }
}

