/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.flipkart.flux.config.FileLocator;
import com.flipkart.flux.resource.FluxResource;
import com.flipkart.flux.resource.StateMachineResource;
import com.flipkart.flux.resource.StatusResource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class ContainerModule
extends AbstractModule {
    protected void configure() {
    }

    @Named(value="DashboardContext")
    @Provides
    @Singleton
    WebAppContext getDashboardWebAppContext() {
        File[] files;
        String path = null;
        for (File file : files = FileLocator.findDirectories("packaged/webapps/dashboard/WEB-INF", null)) {
            String fileToString = file.toString();
            if (fileToString.contains(".jar!") && fileToString.startsWith("file:/")) {
                if (!(fileToString = fileToString.replace("file:/", "jar:file:/")).contains("runtime-")) continue;
                path = fileToString;
                break;
            }
            if (!fileToString.contains("dashboard")) continue;
            path = fileToString;
            break;
        }
        if (path.endsWith("WEB-INF")) {
            path = path.replace("WEB-INF", "");
        }
        WebAppContext webAppContext = new WebAppContext(path, "/admin");
        return webAppContext;
    }

    @Named(value="DashboardJettyServer")
    @Provides
    @Singleton
    Server getDashboardJettyServer(@Named(value="Dashboard.service.port") int port, @Named(value="Dashboard.service.acceptors") int acceptorThreads, @Named(value="Dashboard.service.selectors") int selectorThreads, @Named(value="Dashboard.service.workers") int maxWorkerThreads, @Named(value="DashboardContext") WebAppContext webappContext) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        server.setHandler((Handler)webappContext);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="APIJettyServer")
    @Provides
    @Singleton
    Server getAPIJettyServer(@Named(value="Api.service.port") int port, @Named(value="APIResourceConfig") ResourceConfig resourceConfig, ObjectMapper objectMapper) throws URISyntaxException, UnknownHostException {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(objectMapper);
        resourceConfig.register((Object)provider);
        Server server = JettyHttpContainerFactory.createServer((URI)UriBuilder.fromUri((String)("http://" + InetAddress.getLocalHost().getHostAddress() + "/api")).port(port).build(new Object[0]), (ResourceConfig)resourceConfig);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="APIResourceConfig")
    @Singleton
    @Provides
    public ResourceConfig getAPIResourceConfig(FluxResource fluxUIResource, StateMachineResource stateMachineResource, StatusResource statusResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)fluxUIResource);
        resourceConfig.register((Object)stateMachineResource);
        resourceConfig.register((Object)statusResource);
        return resourceConfig;
    }

    @Provides
    @Singleton
    ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }
}

