/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.dao.AuditDAOImpl;
import com.flipkart.flux.dao.EventsDAOImpl;
import com.flipkart.flux.dao.StateMachinesDAOImpl;
import com.flipkart.flux.dao.StatesDAOImpl;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.guice.module.SessionFactoryProvider;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.type.BlobType;
import com.flipkart.flux.type.SetJsonType;
import com.flipkart.flux.type.StoreFQNType;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Provider;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.UserType;

public class HibernateModule
extends AbstractModule {
    public static final String FLUX_HIBERNATE_CONFIG_NAME_SPACE = "flux.Hibernate";

    protected void configure() {
        this.bind(AuditDAO.class).to(AuditDAOImpl.class).in(Singleton.class);
        this.bind(EventsDAO.class).to(EventsDAOImpl.class).in(Singleton.class);
        this.bind(StateMachinesDAO.class).to(StateMachinesDAOImpl.class).in(Singleton.class);
        this.bind(StatesDAO.class).to(StatesDAOImpl.class).in(Singleton.class);
        SessionFactoryProvider sessionFactoryProvider = new SessionFactoryProvider();
        this.requestInjection(sessionFactoryProvider);
        this.bind(SessionFactory.class).toProvider((Provider)sessionFactoryProvider).in(Singleton.class);
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor((Provider)sessionFactoryProvider);
        this.bindInterceptor(Matchers.not((Matcher)Matchers.inPackage((Package)MessageDao.class.getPackage())), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.registerTypeOverride((UserType)new BlobType(), new String[]{"BlobType"});
        configuration.registerTypeOverride((UserType)new StoreFQNType(), new String[]{"StoreFQNOnly"});
        configuration.registerTypeOverride((UserType)new SetJsonType(), new String[]{"SetJsonType"});
        configuration.addAnnotatedClass(AuditRecord.class);
        configuration.addAnnotatedClass(Event.class);
        configuration.addAnnotatedClass(State.class);
        configuration.addAnnotatedClass(StateMachine.class);
    }

    @Provides
    @Singleton
    @Named(value="fluxHibernateConfiguration")
    public org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(FLUX_HIBERNATE_CONFIG_NAME_SPACE);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configuration.addProperties(configProperties);
        return configuration;
    }
}

