/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventAndExecutionData;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.controller.WorkFlowExecutionController;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.EventsDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.exception.IllegalEventException;
import com.flipkart.flux.exception.UnknownStateMachine;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.metrics.iface.MetricsClient;
import com.flipkart.flux.representation.IllegalRepresentationException;
import com.flipkart.flux.representation.StateMachinePersistenceService;
import com.flipkart.flux.resource.FsmGraph;
import com.flipkart.flux.resource.FsmGraphEdge;
import com.flipkart.flux.resource.FsmGraphVertex;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/api/machines")
@Named
public class StateMachineResource {
    private static final String TRIGGER = " ";
    private static final String CORRELATION_ID = "correlationId";
    private StateMachinePersistenceService stateMachinePersistenceService;
    private WorkFlowExecutionController workFlowExecutionController;
    private StateMachinesDAO stateMachinesDAO;
    private StatesDAO statesDAO;
    private EventsDAO eventsDAO;
    private AuditDAO auditDAO;
    private ObjectMapper objectMapper;
    private MetricsClient metricsClient;
    private static final Logger logger = LoggerFactory.getLogger(StateMachineResource.class);

    @Inject
    public StateMachineResource(EventsDAO eventsDAO, StateMachinePersistenceService stateMachinePersistenceService, AuditDAO auditDAO, StateMachinesDAO stateMachinesDAO, StatesDAO statesDAO, WorkFlowExecutionController workFlowExecutionController, MetricsClient metricsClient) {
        this.eventsDAO = eventsDAO;
        this.stateMachinePersistenceService = stateMachinePersistenceService;
        this.stateMachinesDAO = stateMachinesDAO;
        this.statesDAO = statesDAO;
        this.auditDAO = auditDAO;
        this.workFlowExecutionController = workFlowExecutionController;
        this.objectMapper = new ObjectMapper();
        this.metricsClient = metricsClient;
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response createStateMachine(StateMachineDefinition stateMachineDefinition) throws Exception {
        if (stateMachineDefinition == null) {
            throw new IllegalRepresentationException("State machine definition is empty");
        }
        StateMachine stateMachine = null;
        try {
            stateMachine = this.createAndInitStateMachine(stateMachineDefinition);
            this.metricsClient.markMeter(stateMachine.getName());
        }
        catch (ConstraintViolationException ex) {
            return Response.status((int)Response.Status.CONFLICT.getStatusCode()).entity(ex.getCause() != null ? ex.getCause().getMessage() : null).build();
        }
        return Response.status((int)Response.Status.CREATED.getStatusCode()).entity((Object)stateMachine.getId()).build();
    }

    @Transactional
    protected StateMachine createAndInitStateMachine(StateMachineDefinition stateMachineDefinition) throws Exception {
        StateMachine stateMachine = this.stateMachinePersistenceService.createStateMachine(stateMachineDefinition);
        logger.info("Created state machine with Id: {} and correlation Id: {}", (Object)stateMachine.getId(), (Object)stateMachine.getCorrelationId());
        this.workFlowExecutionController.initAndStart(stateMachine);
        return stateMachine;
    }

    @POST
    @Path(value="/{machineId}/context/events")
    @Timed
    public Response submitEvent(@PathParam(value="machineId") String machineId, @QueryParam(value="searchField") String searchField, EventData eventData) throws Exception {
        logger.info("Received event: {} for state machine: {}", (Object)eventData.getName(), (Object)machineId);
        return this.postEvent(machineId, searchField, eventData);
    }

    @POST
    @Path(value="/{machineId}/context/eventandstatus")
    @Timed
    public Response submitEvent(@PathParam(value="machineId") String machineId, EventAndExecutionData eventAndExecutionData) throws Exception {
        EventData eventData = eventAndExecutionData.getEventData();
        ExecutionUpdateData executionUpdateData = eventAndExecutionData.getExecutionUpdateData();
        logger.info("Received event: {} from state: {} for state machine: {}", new Object[]{eventData.getName(), executionUpdateData.getTaskId(), machineId});
        this.updateTaskStatus(Long.valueOf(machineId), executionUpdateData.getTaskId(), executionUpdateData);
        return this.postEvent(machineId, null, eventData);
    }

    private Response postEvent(String machineId, String searchField, EventData eventData) {
        try {
            if (searchField != null) {
                if (!searchField.equals(CORRELATION_ID)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                this.workFlowExecutionController.postEvent(eventData, null, machineId);
            } else {
                this.workFlowExecutionController.postEvent(eventData, Long.valueOf(machineId), null);
            }
        }
        catch (IllegalEventException | UnknownStateMachine ex) {
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)ex.getMessage()).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/{machineId}/{stateId}/status")
    @Transactional
    @Timed
    public Response updateStatus(@PathParam(value="machineId") Long machineId, @PathParam(value="stateId") Long stateId, ExecutionUpdateData executionUpdateData) throws Exception {
        this.updateTaskStatus(machineId, stateId, executionUpdateData);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    private void updateTaskStatus(Long machineId, Long stateId, ExecutionUpdateData executionUpdateData) {
        Status updateStatus = null;
        switch (executionUpdateData.getStatus()) {
            case initialized: {
                updateStatus = Status.initialized;
                break;
            }
            case running: {
                updateStatus = Status.running;
                break;
            }
            case completed: {
                updateStatus = Status.completed;
                break;
            }
            case cancelled: {
                updateStatus = Status.cancelled;
                break;
            }
            case errored: {
                updateStatus = Status.errored;
                break;
            }
            case sidelined: {
                updateStatus = Status.sidelined;
            }
        }
        this.workFlowExecutionController.updateExecutionStatus(machineId, stateId, updateStatus, executionUpdateData.getRetrycount(), executionUpdateData.getCurrentRetryCount(), executionUpdateData.getErrorMessage(), executionUpdateData.isDeleteFromRedriver());
    }

    @POST
    @Path(value="/{machineId}/{stateId}/retries/inc")
    @Transactional
    public Response incrementRetry(@PathParam(value="machineId") Long machineId, @PathParam(value="stateId") Long stateId) throws Exception {
        this.workFlowExecutionController.incrementExecutionRetries(machineId, stateId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/redrivetask/{taskId}")
    @Timed
    public Response redriveTask(@PathParam(value="taskId") Long taskId) throws Exception {
        this.workFlowExecutionController.redriveTask(taskId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @PUT
    @Path(value="/{machineId}/cancel")
    public void cancelExecution(@PathParam(value="machineId") Long machineId) {
    }

    @GET
    @Path(value="/{machineId}/fsmdata")
    @Produces(value={"application/json"})
    public Response getFsmGraphData(@PathParam(value="machineId") String machineId) throws IOException {
        return Response.status((int)200).entity((Object)this.getGraphData(machineId)).build();
    }

    @GET
    @Path(value="/{stateMachineName}/states/errored")
    @Produces(value={"application/json"})
    public Response getErroredStates(@PathParam(value="stateMachineName") String stateMachineName, @QueryParam(value="fromSmId") Long fromStateMachineId, @QueryParam(value="toSmId") Long toStateMachineId) {
        if (fromStateMachineId == null || fromStateMachineId < 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"start of the range not provided or invalid").build();
        }
        long limit = fromStateMachineId + 1000000L;
        toStateMachineId = toStateMachineId == null || toStateMachineId < fromStateMachineId ? fromStateMachineId : Math.min(limit, toStateMachineId);
        return Response.status((int)200).entity((Object)this.statesDAO.findErroredStates(stateMachineName, fromStateMachineId, toStateMachineId)).build();
    }

    @GET
    @Path(value="/{stateMachineName}/states/erroredbytime")
    @Produces(value={"application/json"})
    public Response getErroredStatesByTime(@PathParam(value="stateMachineName") String stateMachineName, @QueryParam(value="fromTime") String fromTime, @QueryParam(value="toTime") String toTime, @QueryParam(value="stateName") String stateName) throws Exception {
        Timestamp toTimestamp;
        if (fromTime == null || toTime == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Required params fromTime/toTime are not provided").build();
        }
        Timestamp fromTimestamp = Timestamp.valueOf(fromTime);
        if (fromTimestamp.after(toTimestamp = Timestamp.valueOf(toTime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("fromTime: " + fromTime + " should be before toTime: " + toTime)).build();
        }
        return Response.status((int)200).entity((Object)this.statesDAO.findErroredStates(stateMachineName, fromTimestamp, toTimestamp, stateName)).build();
    }

    @PUT
    @Path(value="/{stateMachineId}/{stateId}/unsideline")
    @Produces(value={"application/json"})
    @Transactional
    public Response unsidelineState(@PathParam(value="stateMachineId") Long stateMachineId, @PathParam(value="stateId") Long stateId) {
        this.workFlowExecutionController.unsidelineState(stateMachineId, stateId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    private FsmGraph getGraphData(String machineId) throws IOException {
        Long fsmId = null;
        try {
            fsmId = Long.valueOf(machineId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StateMachine stateMachine = fsmId != null ? this.stateMachinesDAO.findById(fsmId) : this.stateMachinesDAO.findByCorrelationId(machineId);
        if (stateMachine == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("State machine with Id: " + machineId + " not found")).build());
        }
        FsmGraph fsmGraph = new FsmGraph();
        LinkedList<Long> erroredStateIds = new LinkedList<Long>();
        for (State state2 : stateMachine.getStates()) {
            if (state2.getStatus() != Status.errored && state2.getStatus() != Status.sidelined) continue;
            erroredStateIds.add(state2.getId());
        }
        Collections.sort(erroredStateIds);
        fsmGraph.setErroredStateIds(erroredStateIds);
        fsmGraph.setStateMachineId(stateMachine.getId());
        fsmGraph.setCorrelationId(stateMachine.getCorrelationId());
        fsmGraph.setFsmVersion(stateMachine.getVersion());
        fsmGraph.setFsmName(stateMachine.getName());
        Map<String, Event> stateMachineEvents = this.eventsDAO.findBySMInstanceId(stateMachine.getId()).stream().collect(Collectors.toMap(Event::getName, event -> event));
        HashSet<String> allOutputEventNames = new HashSet<String>();
        RAMContext ramContext = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        for (State state3 : stateMachine.getStates()) {
            FsmGraphVertex vertex = new FsmGraphVertex(state3.getId(), this.getStateDisplayName(state3.getName()));
            if (state3.getOutputEvent() != null) {
                EventDefinition eventDefinition = (EventDefinition)this.objectMapper.readValue(state3.getOutputEvent(), EventDefinition.class);
                Event outputEvent = stateMachineEvents.get(eventDefinition.getName());
                fsmGraph.addVertex(vertex, new FsmGraphEdge(this.getEventDisplayName(outputEvent.getName()), state3.getStatus().name(), outputEvent.getEventSource(), outputEvent.getEventData()));
                Set dependantStates = ramContext.getDependantStates(outputEvent.getName());
                dependantStates.forEach(aState -> fsmGraph.addOutgoingEdge(vertex, aState.getId()));
                allOutputEventNames.add(outputEvent.getName());
                continue;
            }
            fsmGraph.addVertex(vertex, new FsmGraphEdge(null, state3.getStatus().name(), null, null));
        }
        Set initialStates = ramContext.getInitialStates(Collections.emptySet());
        if (!initialStates.isEmpty()) {
            FsmGraphEdge initEdge = new FsmGraphEdge(TRIGGER, Event.EventStatus.triggered.name(), TRIGGER, null);
            initialStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        }
        HashSet<String> eventsGivenOnWorkflowTrigger = new HashSet<String>(stateMachineEvents.keySet());
        eventsGivenOnWorkflowTrigger.removeAll(allOutputEventNames);
        eventsGivenOnWorkflowTrigger.forEach(workflowTriggeredEventName -> {
            Event correspondingEvent = (Event)stateMachineEvents.get(workflowTriggeredEventName);
            FsmGraphEdge initEdge = new FsmGraphEdge(this.getEventDisplayName((String)workflowTriggeredEventName), correspondingEvent.getStatus().name(), correspondingEvent.getEventSource(), correspondingEvent.getEventData());
            Set dependantStates = ramContext.getDependantStates(workflowTriggeredEventName);
            dependantStates.forEach(state -> initEdge.addOutgoingVertex(state.getId()));
            fsmGraph.addInitStateEdge(initEdge);
        });
        fsmGraph.setAuditData(this.auditDAO.findBySMInstanceId(stateMachine.getId()));
        return fsmGraph;
    }

    private String getEventDisplayName(String eventName) {
        return eventName == null ? null : this.getDisplayName(eventName.substring(eventName.lastIndexOf(".") + 1));
    }

    private String getStateDisplayName(String stateName) {
        return this.getDisplayName(stateName);
    }

    private String getDisplayName(String label) {
        if (label == null) {
            return null;
        }
        String words = label.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), TRIGGER);
        StringBuffer sb = new StringBuffer();
        for (String s : words.split(TRIGGER)) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
            sb.append(TRIGGER);
        }
        return sb.toString().trim();
    }
}

