/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.representation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.dao.iface.AuditDAO;
import com.flipkart.flux.dao.iface.StateMachinesDAO;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.representation.EventPersistenceService;
import com.flipkart.flux.representation.IllegalRepresentationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class StateMachinePersistenceService {
    private StateMachinesDAO stateMachinesDAO;
    private AuditDAO auditDAO;
    private EventPersistenceService eventPersistenceService;
    private final ObjectMapper objectMapper;
    private Integer maxRetryCount;

    @Inject
    public StateMachinePersistenceService(StateMachinesDAO stateMachinesDAO, AuditDAO auditDAO, EventPersistenceService eventPersistenceService, @Named(value="task.maxTaskRetryCount") Integer maxRetryCount) {
        this.stateMachinesDAO = stateMachinesDAO;
        this.auditDAO = auditDAO;
        this.eventPersistenceService = eventPersistenceService;
        this.maxRetryCount = maxRetryCount;
        this.objectMapper = new ObjectMapper();
    }

    public StateMachine createStateMachine(StateMachineDefinition stateMachineDefinition) {
        Map eventDataMap = stateMachineDefinition.getEventDataMap();
        Set<Event> allEvents = this.createAllEvents(eventDataMap);
        Set stateDefinitions = stateMachineDefinition.getStates();
        HashSet<State> states = new HashSet<State>();
        for (StateDefinition stateDefinition : stateDefinitions) {
            State state = this.convertStateDefinitionToState(stateDefinition);
            states.add(state);
        }
        StateMachine stateMachine = new StateMachine(stateMachineDefinition.getVersion(), stateMachineDefinition.getName(), stateMachineDefinition.getDescription(), states, stateMachineDefinition.getCorrelationId());
        this.stateMachinesDAO.create(stateMachine);
        for (Event event : allEvents) {
            event.setStateMachineInstanceId(stateMachine.getId());
            this.eventPersistenceService.persistEvent(event);
        }
        for (State state : stateMachine.getStates()) {
            this.auditDAO.create(new AuditRecord(stateMachine.getId(), state.getId(), Long.valueOf(0L), Status.initialized, null, null));
        }
        return stateMachine;
    }

    private Set<Event> createAllEvents(Map<EventDefinition, EventData> eventDataMap) {
        HashSet<Event> allEvents = new HashSet<Event>();
        for (Map.Entry<EventDefinition, EventData> currentEventDefinitionAndData : eventDataMap.entrySet()) {
            Event currentEvent = this.eventPersistenceService.convertEventDefinitionToEvent(currentEventDefinitionAndData.getKey());
            if (currentEventDefinitionAndData.getValue() != null) {
                currentEvent.setEventData(currentEventDefinitionAndData.getValue().getData());
                currentEvent.setEventSource(currentEventDefinitionAndData.getValue().getEventSource());
                currentEvent.setStatus(Event.EventStatus.triggered);
            }
            allEvents.add(currentEvent);
        }
        return allEvents;
    }

    private State convertStateDefinitionToState(StateDefinition stateDefinition) {
        try {
            List eventDefinitions = stateDefinition.getDependencies();
            LinkedList<String> events = new LinkedList<String>();
            if (eventDefinitions != null) {
                for (EventDefinition e : eventDefinitions) {
                    events.add(e.getName());
                }
            }
            State state = new State(stateDefinition.getVersion(), stateDefinition.getName(), stateDefinition.getDescription(), stateDefinition.getOnEntryHook(), stateDefinition.getTask(), stateDefinition.getOnExitHook(), events, Long.valueOf(Math.min(stateDefinition.getRetryCount(), (long)this.maxRetryCount.intValue())), stateDefinition.getTimeout(), stateDefinition.getOutputEvent() != null ? this.objectMapper.writeValueAsString((Object)stateDefinition.getOutputEvent()) : null, Status.initialized, null, Long.valueOf(0L));
            return state;
        }
        catch (Exception e) {
            throw new IllegalRepresentationException("Unable to create state domain object", e);
        }
    }
}

