/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.initializer;

import com.flipkart.flux.MigrationUtil.MigrationsRunner;
import com.flipkart.flux.client.FluxClientInterceptorModule;
import com.flipkart.flux.guice.module.AkkaModule;
import com.flipkart.flux.guice.module.ConfigModule;
import com.flipkart.flux.guice.module.ContainerModule;
import com.flipkart.flux.guice.module.DeploymentUnitModule;
import com.flipkart.flux.guice.module.HibernateModule;
import com.flipkart.flux.impl.boot.TaskModule;
import com.flipkart.flux.initializer.OrderedComponentBooter;
import com.flipkart.polyguice.core.support.Polyguice;
import com.google.inject.Module;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxInitializer {
    private static final Logger logger = LoggerFactory.getLogger(FluxInitializer.class);
    private String hostName;
    private static final MessageFormat STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n Flux             ___          \n          ___    /   \\        \n         /   \\__| ( ) |            Startup Time : {0} ms\n   ___  | ( ) |  \\___/             Host Name: {1} \n  /   \\/ \\___/     \\___         \n | ( ) |   \\___    /   \\   \n  \\___/    /   \\__| ( ) |      \n          | ( ) |  \\___/     \n           \\___/        \n*************************************************************************");
    private Polyguice fluxRuntimeContainer;

    public FluxInitializer() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.fluxRuntimeContainer = new Polyguice();
    }

    public static void main(String[] args) throws Exception {
        String command = "start";
        if (args != null && args.length > 0) {
            command = args[0];
        }
        FluxInitializer fluxInitializer = new FluxInitializer();
        switch (command) {
            case "start": {
                fluxInitializer.start();
                break;
            }
            case "migrate": {
                if (args.length < 2) {
                    throw new RuntimeException("<migrate> must be followed with db name");
                }
                if (!args[1].equals("flux") && !args[1].equals("flux_redriver")) {
                    throw new RuntimeException("<migrate> works only for 'flux' or 'flux_redriver'");
                }
                fluxInitializer.migrate(args[1]);
            }
        }
    }

    private void loadFluxRuntimeContainer() {
        logger.debug("loading flux runtime container");
        ConfigModule configModule = new ConfigModule();
        this.fluxRuntimeContainer.modules(new Module[]{configModule, new HibernateModule(), new ContainerModule(), new DeploymentUnitModule(), new AkkaModule(), new TaskModule(), new FluxClientInterceptorModule()});
        this.fluxRuntimeContainer.scanPackage("com.flipkart.flux");
        this.fluxRuntimeContainer.registerConfigurationProvider(configModule.getConfigProvider());
        this.fluxRuntimeContainer.prepare();
    }

    private void start() throws Exception {
        logger.info("** Flux starting up... **");
        long start = System.currentTimeMillis();
        this.loadFluxRuntimeContainer();
        OrderedComponentBooter instance = (OrderedComponentBooter)this.fluxRuntimeContainer.getComponentContext().getInstance(OrderedComponentBooter.class);
        Object[] displayArgs = new Object[]{System.currentTimeMillis() - start, this.hostName};
        logger.info(STARTUP_DISPLAY.format(displayArgs));
        logger.info("** Flux startup complete **");
    }

    private void migrate(String dbName) {
        this.loadFluxRuntimeContainer();
        MigrationsRunner migrationsRunner = (MigrationsRunner)this.fluxRuntimeContainer.getComponentContext().getInstance(MigrationsRunner.class);
        migrationsRunner.migrate(dbName);
    }
}

