/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.deploymentunit;

import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitUtil;
import com.flipkart.flux.deploymentunit.iface.DeploymentUnitsManager;
import com.flipkart.flux.deploymentunit.iface.ExecutableLoader;
import com.flipkart.flux.exception.DuplicateDeploymentUnitException;
import com.flipkart.flux.guice.annotation.ManagedEnv;
import com.flipkart.flux.registry.TaskExecutableImpl;
import com.flipkart.polyguice.core.Initializable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Singleton
public class DeploymentUnitsManagerImpl
implements DeploymentUnitsManager,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentUnitsManagerImpl.class);
    @Inject
    private DeploymentUnitUtil deploymentUnitUtil;
    @Inject
    private ExecutableLoader executableLoader;
    @Inject
    @ManagedEnv
    private ExecutableRegistry executableRegistry;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Map<String, CopyOnWriteArrayList<DeploymentUnit>> deploymentUnitMap = new ConcurrentHashMap<String, CopyOnWriteArrayList<DeploymentUnit>>();

    @Override
    public DeploymentUnit load(String name, Integer version) throws Exception {
        logger.info("LOADING deployment Unit: {}/{}", (Object)name, (Object)version);
        Path deploymentUnitDir = Paths.get(name, version.toString());
        DeploymentUnit latestUnit = this.getLatestFromMap(name);
        if (latestUnit != null) {
            if (latestUnit.getVersion().equals(version)) {
                throw new DuplicateDeploymentUnitException("Deployment Unit with name: " + name + " version: " + version + " exists already");
            }
            if (latestUnit.getVersion() > version) {
                throw new FluxError(FluxError.ErrorType.runtime, "Cannot load the deploymentUnit of an older version. Latest version: " + latestUnit.getVersion(), null);
            }
        }
        DeploymentUnit loadedUnit = this.deploymentUnitUtil.getDeploymentUnit(deploymentUnitDir);
        this.addToMap(loadedUnit);
        try {
            Map<String, Executable> loadedExes = this.executableLoader.loadExecutables(loadedUnit);
            for (String taskId : loadedExes.keySet()) {
                this.executableRegistry.registerTask(taskId, loadedExes.get(taskId));
            }
        }
        catch (FluxError fe) {
            this.unload(loadedUnit.getName(), loadedUnit.getVersion());
            throw fe;
        }
        return loadedUnit;
    }

    @Override
    public void unload(String name, Integer version) {
        logger.warn("UNLOADING Deployment Unit: {}/{}", (Object)name, (Object)version);
        DeploymentUnit foundUnit = this.getFromMap(name, version);
        if (foundUnit == null) {
            return;
        }
        foundUnit.close();
        this.removeFromMap(name, version);
        for (String taskId : foundUnit.getTaskMethods().keySet()) {
            Executable exe = this.executableRegistry.getTask(taskId);
            if (exe instanceof TaskExecutableImpl) {
                if (((TaskExecutableImpl)exe).getDeploymentUnitClassLoader() != foundUnit.getDeploymentUnitClassLoader()) continue;
                this.executableRegistry.unregisterTask(taskId);
                continue;
            }
            logger.warn("Executable here must be of type TaskExecutableImpl. Found " + exe);
        }
    }

    @Override
    public Collection<DeploymentUnit> getAllDeploymentUnits() {
        return this.deploymentUnitMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void initialize() {
        List<Path> paths = Collections.EMPTY_LIST;
        try {
            paths = this.deploymentUnitUtil.listAllDirectoryUnits();
        }
        catch (IOException e) {
            logger.error("Failed to list all directories of deploymentUnits");
        }
        if (paths == null || paths.isEmpty()) {
            return;
        }
        List unitFutures = paths.stream().map(path -> this.executorService.submit(() -> this.deploymentUnitUtil.getDeploymentUnit((Path)path))).collect(Collectors.toList());
        for (int index = 0; index < unitFutures.size(); ++index) {
            try {
                DeploymentUnit deploymentUnit = (DeploymentUnit)((Future)unitFutures.get(index)).get();
                this.addToMap(deploymentUnit);
                continue;
            }
            catch (ExecutionException ee) {
                logger.error("Unexpected error occurred while loading deploymentUnit: ", (Object)paths.get(index), (Object)ee);
                continue;
            }
            catch (InterruptedException ie) {
                logger.error("DeploymentUnit loading got interrupted: {}", (Object)paths.get(index), (Object)ie);
            }
        }
        List unitsFutures = this.deploymentUnitMap.keySet().stream().map(name -> this.executorService.submit(() -> {
            List units = this.deploymentUnitMap.get(name);
            ConcurrentHashMap<String, Executable> executableMap = new ConcurrentHashMap<String, Executable>();
            Boolean loadFailed = false;
            for (DeploymentUnit unit : units) {
                if (!loadFailed.booleanValue()) {
                    try {
                        Map<String, Executable> loadedExecutables = this.executableLoader.loadExecutables(unit);
                        executableMap.putAll(loadedExecutables);
                    }
                    catch (FluxError fe) {
                        logger.error("Unexpected error occurred while loading executables from deploymentUnit: {}/{}", new Object[]{unit.getName(), unit.getVersion(), fe});
                        loadFailed = true;
                    }
                    continue;
                }
                this.unload(unit.getName(), unit.getVersion());
            }
            for (String taskId : executableMap.keySet()) {
                this.executableRegistry.registerTask(taskId, (Executable)executableMap.get(taskId));
            }
        })).collect(Collectors.toList());
        for (Future unitsFuture : unitsFutures) {
            try {
                unitsFuture.get();
            }
            catch (InterruptedException e) {
                logger.error("Loading executables interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("Unexpected error occurred while loading executables.", (Throwable)e);
            }
        }
    }

    private void addToMap(DeploymentUnit unit) {
        logger.debug("adding deployingUnit: {}/{}", (Object)unit.getName(), (Object)unit.getVersion());
        if (!this.deploymentUnitMap.containsKey(unit.getName())) {
            this.deploymentUnitMap.put(unit.getName(), new CopyOnWriteArrayList<DeploymentUnit>(Arrays.asList(unit)));
            return;
        }
        List deploymentUnits = this.deploymentUnitMap.get(unit.getName());
        List newSortedList = Stream.concat(deploymentUnits.stream(), Stream.of(unit)).sorted((e1, e2) -> Integer.compare(e1.getVersion(), e2.getVersion())).collect(Collectors.toList());
        this.deploymentUnitMap.put(unit.getName(), new CopyOnWriteArrayList(newSortedList));
    }

    private void removeFromMap(String name, Integer version) {
        logger.debug("removing deploymentUnit: {}/{}", (Object)name, (Object)version);
        List units = this.deploymentUnitMap.get(name);
        if (!CollectionUtils.isEmpty((Collection)units)) {
            units.removeIf(e -> e.getVersion().equals(version));
        }
    }

    private DeploymentUnit getFromMap(String name, Integer version) {
        List units = this.deploymentUnitMap.get(name);
        if (units != null) {
            return units.stream().filter(e -> e.getVersion().equals(version)).findFirst().orElse(null);
        }
        return null;
    }

    private DeploymentUnit getLatestFromMap(String name) {
        List units = this.deploymentUnitMap.get(name);
        if (!CollectionUtils.isEmpty((Collection)units)) {
            return (DeploymentUnit)units.get(units.size() - 1);
        }
        return null;
    }
}

