/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import com.flipkart.flux.dao.AbstractDAO;
import com.flipkart.flux.dao.iface.StatesDAO;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.google.inject.name.Named;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Query;

public class StatesDAOImpl
extends AbstractDAO<State>
implements StatesDAO {
    @Inject
    public StatesDAOImpl(@Named(value="fluxSessionFactoryContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    @Override
    @Transactional
    public State create(State state) {
        return super.save(state);
    }

    @Override
    @Transactional
    public void updateState(State state) {
        super.update(state);
    }

    @Override
    @Transactional
    public void updateStatus(Long stateId, Long stateMachineId, Status status) {
        Query query = this.currentSession().createQuery("update State set status = :status where id = :stateId and stateMachineId = :stateMachineId");
        query.setString("status", status != null ? status.toString() : null);
        query.setLong("stateId", stateId.longValue());
        query.setLong("stateMachineId", stateMachineId.longValue());
        query.executeUpdate();
    }

    @Override
    @Transactional
    public void updateRollbackStatus(Long stateId, Long stateMachineId, Status rollbackStatus) {
        Query query = this.currentSession().createQuery("update State set rollbackStatus = :rollbackStatus where id = :stateId and stateMachineId = :stateMachineId");
        query.setString("rollbackStatus", rollbackStatus != null ? rollbackStatus.toString() : null);
        query.setLong("stateId", stateId.longValue());
        query.setLong("stateMachineId", stateMachineId.longValue());
        query.executeUpdate();
    }

    @Override
    @Transactional
    public void incrementRetryCount(Long stateId, Long stateMachineId) {
        Query query = this.currentSession().createQuery("update State set attemptedNoOfRetries = attemptedNoOfRetries + 1 where id = :stateId and stateMachineId = :stateMachineId");
        query.setLong("stateId", stateId.longValue());
        query.setLong("stateMachineId", stateMachineId.longValue());
        query.executeUpdate();
    }

    @Override
    @Transactional
    public State findById(Long id) {
        return (State)super.findById(State.class, id);
    }

    @Override
    @Transactional
    @SelectDataSource(value=DataSourceType.READ_ONLY)
    public List findErroredStates(String stateMachineName, Long fromStateMachineId, Long toStateMachineId) {
        Query query = this.currentSession().createQuery("select state.stateMachineId, state.id, state.status from StateMachine sm join sm.states state where sm.id between :fromStateMachineId and :toStateMachineId and sm.name = :stateMachineName and state.status in ('errored', 'sidelined', 'cancelled')");
        query.setLong("fromStateMachineId", fromStateMachineId.longValue());
        query.setLong("toStateMachineId", toStateMachineId.longValue());
        query.setString("stateMachineName", stateMachineName);
        return query.list();
    }

    @Override
    @Transactional
    @SelectDataSource(value=DataSourceType.READ_ONLY)
    public List findErroredStates(String stateMachineName, Timestamp fromTime, Timestamp toTime, String stateName) {
        Query query;
        if (stateName == null) {
            query = this.currentSession().createQuery("select state.stateMachineId, state.id, state.status from StateMachine sm join sm.states state where sm.id between (select min(id) from StateMachine where createdAt >= :fromTime) and (select max(id) from StateMachine where createdAt <= :toTime) and sm.name = :stateMachineName and state.status in ('errored', 'sidelined', 'cancelled')");
        } else {
            query = this.currentSession().createQuery("select state.stateMachineId, state.id, state.status from StateMachine sm join sm.states state where sm.id between (select min(id) from StateMachine where createdAt >= :fromTime) and (select max(id) from StateMachine where createdAt <= :toTime) and sm.name = :stateMachineName and state.name = :stateName and state.status in ('errored', 'sidelined', 'cancelled')");
            query.setString("stateName", stateName);
        }
        query.setString("stateMachineName", stateMachineName);
        query.setTimestamp("fromTime", (Date)fromTime);
        query.setTimestamp("toTime", (Date)toTime);
        return query.list();
    }
}

