/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.FluxRuntimeService;
import com.flipkart.flux.api.WorkflowStateSummary;
import com.flipkart.flux.api.WorkflowStatesDetail;
import com.flipkart.flux.api.WorkflowSummary;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/api/teams")
@Named
@Singleton
public class FluxResource {
    private final FluxRuntimeService fluxRunTimeService;
    private ObjectMapper objectMapper;

    @Inject
    public FluxResource(FluxRuntimeService fluxRunTimeService, ObjectMapper objectMapper) {
        this.fluxRunTimeService = fluxRunTimeService;
        this.objectMapper = objectMapper;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{teamName}/workflows/summary")
    public Response getSummary(@PathParam(value="teamName") String teamName) {
        try {
            WorkflowSummary workflowSummary = this.fluxRunTimeService.getTeamWorkfloWSummary(teamName);
            String response = this.objectMapper.writeValueAsString((Object)workflowSummary);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)response).build();
        }
        catch (Exception e) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{teamName}/workflows/{workflowName}/{version}/{state}/summary")
    public Response getStateSummary(@PathParam(value="teamName") String teamName, @PathParam(value="workflowName") String workflowName, @PathParam(value="version") String version, @PathParam(value="state") String state) {
        try {
            WorkflowStateSummary workFlowStateSummary = this.fluxRunTimeService.getWorkflowStateSummary(teamName, workflowName, version, state);
            String response = this.objectMapper.writeValueAsString((Object)workFlowStateSummary);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)response).build();
        }
        catch (Exception e) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{teamName}/workflows/{workflowName}/{version}/{state}")
    public Response getStateDetail(@PathParam(value="teamName") String teamName, @PathParam(value="workflowName") String workflowName, @PathParam(value="version") String version, @PathParam(value="state") String state, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="index") Integer index) {
        try {
            WorkflowStatesDetail workFlowStatesDetail = this.fluxRunTimeService.getWorkflowStatesDetail(teamName, workflowName, version, state, pageSize, index);
            String response = this.objectMapper.writeValueAsString((Object)workFlowStatesDetail);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)response).build();
        }
        catch (Exception e) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)e.getMessage()).build();
        }
    }
}

