/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.deploymentunit.DeploymentUnit;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jetty.util.ConcurrentHashSet;

public class AkkaModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="routerNames")
    public Set<String> getRouterNames(@Named(value="deploymentUnits") Map<String, DeploymentUnit> deploymentUnitsMap, YamlConfiguration yamlConfiguration) {
        Configuration routerConfig = yamlConfiguration.subset("routers");
        ConcurrentHashSet routerNames = new ConcurrentHashSet();
        Iterator propertyKeys = routerConfig.getKeys();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            String routerName = propertyKey.substring(0, propertyKey.lastIndexOf(46));
            routerNames.add(routerName);
        }
        routerNames.remove("default");
        for (Map.Entry<String, DeploymentUnit> deploymentUnitEntry : deploymentUnitsMap.entrySet()) {
            Set<Method> taskMethods = deploymentUnitEntry.getValue().getTaskMethods();
            routerNames.addAll(taskMethods.stream().map(method -> new MethodId(method).getPrefix()).collect(Collectors.toList()));
        }
        return routerNames;
    }
}

