/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.interceptor;

import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class TransactionInterceptor
implements MethodInterceptor {
    @Inject
    private SessionFactory sessionFactory;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        if (session == null) {
            session = this.sessionFactory.openSession();
            ManagedSessionContext.bind((Session)session);
            transaction = session.getTransaction();
            transaction.begin();
        }
        try {
            Object result = invocation.proceed();
            if (transaction != null) {
                transaction.commit();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            if (transaction != null && session != null) {
                ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
                session.close();
            }
        }
    }
}

