/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractDAO<T> {
    private SessionFactory sessionFactory;

    public AbstractDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public T findById(Class cls, Long id) {
        Criteria criteria = this.currentSession().createCriteria(cls).add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Object object = criteria.uniqueResult();
        Object castedObject = null;
        if (object != null) {
            castedObject = object;
        }
        return (T)castedObject;
    }

    public T save(T object) {
        this.currentSession().save(object);
        return object;
    }

    public void update(T object) {
        this.currentSession().update(object);
    }

    public T saveOrUpdate(T object) {
        this.currentSession().saveOrUpdate(object);
        return object;
    }

    public void delete(T object) {
        this.currentSession().delete(object);
    }
}

