/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.guice.module;

import com.flipkart.polyguice.config.ApacheCommonsConfigProvider;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.flipkart.polyguice.core.ConfigurationProvider;
import com.google.inject.AbstractModule;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Iterator;

public class ConfigModule
extends AbstractModule {
    private URL configUrl;
    private final ConfigurationProvider configProvider;

    public ConfigModule(URL configUrl) {
        this.configUrl = configUrl;
        this.configProvider = new ApacheCommonsConfigProvider().location(configUrl);
    }

    protected void configure() {
        this.bind(ConfigurationProvider.class).toInstance((Object)this.configProvider);
        this.bindConfigProperties(this.configUrl);
    }

    private void bindConfigProperties(URL url) {
        try {
            YamlConfiguration yamlConfiguration = new YamlConfiguration(url);
            this.bind(YamlConfiguration.class).toInstance((Object)yamlConfiguration);
            Iterator propertyKeys = yamlConfiguration.getKeys();
            while (propertyKeys.hasNext()) {
                String propertyKey = (String)propertyKeys.next();
                Object propertyValue = yamlConfiguration.getProperty(propertyKey);
                LinkedBindingBuilder annotatedWith = this.bind(propertyValue.getClass()).annotatedWith((Annotation)Names.named((String)propertyKey));
                annotatedWith.toInstance(propertyValue);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationProvider getConfigProvider() {
        return this.configProvider;
    }
}

