/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.dao;

import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Order;

@Singleton
public class MessageDao {
    private SessionFactoryContext sessionFactoryContext;

    @Inject
    public MessageDao(@Named(value="redriverSessionFactoryContext") SessionFactoryContext sessionFactoryContext) {
        this.sessionFactoryContext = sessionFactoryContext;
    }

    @Transactional
    public void save(ScheduledMessage scheduledMessage) {
        this.currentSession().saveOrUpdate((Object)scheduledMessage);
    }

    @Transactional
    public List<ScheduledMessage> retrieveOldest(int offset, int rowCount) {
        return this.currentSession().createCriteria(ScheduledMessage.class).addOrder(Order.asc((String)"scheduledTime")).setFirstResult(offset).setMaxResults(rowCount).list();
    }

    @Transactional
    public void deleteInBatch(List<Long> messageIdsToDelete) {
        Query deleteQuery = this.currentSession().createQuery("delete ScheduledMessage s where s.taskId in :msgList ");
        deleteQuery.setParameterList("msgList", messageIdsToDelete);
        deleteQuery.executeUpdate();
    }

    private Session currentSession() {
        return this.sessionFactoryContext.getSessionFactory().getCurrentSession();
    }
}

