/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="ScheduledMessages")
public class ScheduledMessage
implements Serializable {
    @Id
    private Long taskId;
    private long scheduledTime;

    ScheduledMessage() {
    }

    public ScheduledMessage(Long taskId, Long scheduledTime) {
        this();
        this.taskId = taskId;
        this.scheduledTime = scheduledTime;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledMessage that = (ScheduledMessage)o;
        if (this.scheduledTime != that.scheduledTime) {
            return false;
        }
        return this.taskId.equals(that.taskId);
    }

    public int hashCode() {
        int result = this.taskId.hashCode();
        result = 31 * result + (int)(this.scheduledTime ^ this.scheduledTime >>> 32);
        return result;
    }

    public String toString() {
        return "ScheduledMessage{, taskId=" + this.taskId + ", scheduledTime=" + this.scheduledTime + '}';
    }

    public boolean shouldRunNow() {
        return this.scheduledTime <= System.currentTimeMillis();
    }

    public Long timeLeftToRun() {
        return this.scheduledTime - System.currentTimeMillis();
    }

    public Long getTaskId() {
        return this.taskId;
    }
}

