/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.dao;

import com.flipkart.flux.redriver.model.ScheduledMessage;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@Singleton
public class MessageDao {
    private SessionFactory sessionFactory;

    @Inject
    public MessageDao(@Named(value="redriverSessionFactory") SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Transactional
    public void save(ScheduledMessage scheduledMessage) {
        this.currentSession().save((Object)scheduledMessage);
    }

    @Transactional
    public List<ScheduledMessage> retrieveAll() {
        return this.currentSession().createCriteria(ScheduledMessage.class).list();
    }

    @Transactional
    public void deleteInBatch(List<Long> messageIdsToDelete) {
        Query deleteQuery = this.currentSession().createQuery("delete ScheduledMessage s where s.taskId in :msgList ");
        deleteQuery.setParameterList("msgList", messageIdsToDelete);
        deleteQuery.executeUpdate();
    }

    private Session currentSession() {
        return this.sessionFactory.getCurrentSession();
    }
}

