/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.boot;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.redriver.boot.SessionFactoryProvider;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Provider;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;

public class RedriverModule
extends AbstractModule {
    private static final String FLUX_REDRIVER_HIBERNATE_CONFIG_NAME_SPACE = "flux_redriver.Hibernate";

    protected void configure() {
        SessionFactoryProvider sessionFactoryProvider = new SessionFactoryProvider();
        this.requestInjection(sessionFactoryProvider);
        this.bind(SessionFactory.class).annotatedWith((Annotation)Names.named((String)"redriverSessionFactory")).toProvider((Provider)sessionFactoryProvider).in(Singleton.class);
        this.bindInterceptor(Matchers.inPackage((Package)MessageDao.class.getPackage()), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{new TransactionInterceptor((Provider)sessionFactoryProvider)});
    }

    @Provides
    public MetricRegistry metricRegistry() {
        return SharedMetricRegistries.getOrCreate((String)"mainMetricRegistry");
    }

    @Provides
    @Singleton
    @Named(value="redriverHibernateConfiguration")
    public org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(FLUX_REDRIVER_HIBERNATE_CONFIG_NAME_SPACE);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configuration.addProperties(configProperties);
        return configuration;
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.addAnnotatedClass(ScheduledMessage.class);
    }
}

