/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.boot;

import com.flipkart.flux.guice.interceptor.TransactionInterceptor;
import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.impl.SessionFactoryContextImpl;
import com.flipkart.flux.redriver.dao.MessageDao;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.polyguice.config.YamlConfiguration;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.configuration.Configuration;
import org.hibernate.SessionFactory;

public class RedriverModule
extends AbstractModule {
    private static final String FLUX_REDRIVER_HIBERNATE_CONFIG_NAME_SPACE = "flux_redriver.Hibernate";

    protected void configure() {
        Provider provider = this.getProvider(Key.get(SessionFactoryContext.class, (Annotation)Names.named((String)"redriverSessionFactoryContext")));
        this.bindInterceptor(Matchers.inPackage((Package)MessageDao.class.getPackage()), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{new TransactionInterceptor((javax.inject.Provider)provider)});
    }

    @Provides
    @Singleton
    @Named(value="redriverHibernateConfiguration")
    public org.hibernate.cfg.Configuration getConfiguration(YamlConfiguration yamlConfiguration) {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        this.addAnnotatedClassesAndTypes(configuration);
        Configuration hibernateConfig = yamlConfiguration.subset(FLUX_REDRIVER_HIBERNATE_CONFIG_NAME_SPACE);
        Iterator propertyKeys = hibernateConfig.getKeys();
        Properties configProperties = new Properties();
        while (propertyKeys.hasNext()) {
            String propertyKey = (String)propertyKeys.next();
            Object propertyValue = hibernateConfig.getProperty(propertyKey);
            configProperties.put(propertyKey, propertyValue);
        }
        configuration.addProperties(configProperties);
        return configuration;
    }

    @Provides
    @Singleton
    @Named(value="redriverSessionFactoryContext")
    public SessionFactoryContext getSessionFactoryProvider(@Named(value="redriverHibernateConfiguration") org.hibernate.cfg.Configuration configuration) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        HashMap<DataSourceType, SessionFactory> map = new HashMap<DataSourceType, SessionFactory>();
        map.put(DataSourceType.READ_WRITE, sessionFactory);
        return new SessionFactoryContextImpl(map, DataSourceType.READ_WRITE);
    }

    private void addAnnotatedClassesAndTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.addAnnotatedClass(ScheduledMessage.class);
    }
}

