/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.redriver.scheduler;

import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.redriver.model.ScheduledMessageComparator;
import com.flipkart.flux.redriver.service.MessageManagerService;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import java.util.Date;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessageScheduler {
    private final PriorityQueue<ScheduledMessage> messages;
    private final MessageManagerService messageManagerService;
    private static final Logger logger = LoggerFactory.getLogger(MessageScheduler.class);
    private final RedriverRegistry redriverRegistry;
    private SchedulerThread schedulerThread;

    @Inject
    public MessageScheduler(MessageManagerService messageManagerService, RedriverRegistry redriverRegistry) {
        this(messageManagerService, new PriorityQueue<ScheduledMessage>(new ScheduledMessageComparator()), redriverRegistry);
    }

    MessageScheduler(MessageManagerService messageManagerService, PriorityQueue<ScheduledMessage> scheduledMessages, RedriverRegistry redriverRegistry) {
        this.messageManagerService = messageManagerService;
        this.messages = scheduledMessages;
        this.schedulerThread = new SchedulerThread();
        this.redriverRegistry = redriverRegistry;
    }

    public void addMessage(ScheduledMessage scheduledMessage) {
        this.messageManagerService.saveMessage(scheduledMessage);
        this.messages.add(scheduledMessage);
        this.schedulerThread.resumeJobExecution();
    }

    public void removeMessage(Long taskId) {
        Optional<ScheduledMessage> scheduledMessageOptional = this.messages.stream().filter(m -> m.getTaskId().equals(taskId)).findFirst();
        if (scheduledMessageOptional.isPresent()) {
            ScheduledMessage message = scheduledMessageOptional.get();
            this.messages.remove(message);
            this.messageManagerService.scheduleForRemoval(message);
        }
    }

    public void start() {
        this.schedulerThread.start();
    }

    public void stop() {
        this.schedulerThread.halt();
    }

    private class SchedulerThread
    extends Thread {
        private Boolean halted = false;
        private Boolean paused = true;
        private final Object lock = new Object();

        private SchedulerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.ensureNotPaused();
                Object object = this.lock;
                synchronized (object) {
                    if (this.halted.booleanValue()) {
                        return;
                    }
                }
                try {
                    this._run();
                    continue;
                }
                catch (RuntimeException e) {
                    logger.error("Encountered exception during execution", (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error("We were interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void _run() throws InterruptedException {
            ScheduledMessage highestPriorityMessage = (ScheduledMessage)MessageScheduler.this.messages.peek();
            if (highestPriorityMessage != null) {
                if (highestPriorityMessage.shouldRunNow()) {
                    ScheduledMessage messageToSend = (ScheduledMessage)MessageScheduler.this.messages.poll();
                    MessageScheduler.this.redriverRegistry.redriveTask(messageToSend.getTaskId());
                    MessageScheduler.this.messageManagerService.scheduleForRemoval(messageToSend);
                } else {
                    Long timeLeft = highestPriorityMessage.timeLeftToRun();
                    if (timeLeft > 0L) {
                        logger.info("Next job run only at {}", (Object)new Date(highestPriorityMessage.getScheduledTime()));
                        this.sleep(timeLeft);
                    }
                }
            } else {
                this.pauseJobExecution();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureNotPaused() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.paused.booleanValue() && !this.halted.booleanValue()) {
                        logger.info("Paused waiting for resume");
                        this.lock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sleep(Long timeLeft) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeLeft);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseJobExecution() {
            Object object = this.lock;
            synchronized (object) {
                logger.info("Pausing job execution");
                this.paused = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeJobExecution() {
            Object object = this.lock;
            synchronized (object) {
                logger.info("Resuming job execution");
                this.paused = false;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void halt() {
            Object object = this.lock;
            synchronized (object) {
                logger.info("Halting job execution");
                this.halted = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyNewJob() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

