/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.AuditEvent;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.StateDefinition;
import com.flipkart.flux.api.StateMachineDefinition;
import com.flipkart.flux.domain.AuditRecord;
import com.flipkart.flux.domain.Context;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.domain.State;
import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.domain.StateTraversalPath;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.impl.RAMContext;
import com.flipkart.flux.persistence.MultiEntityManager;
import com.flipkart.flux.persistence.PersistenceConstants;
import com.flipkart.flux.persistence.dao.iface.AuditDAOV1;
import com.flipkart.flux.persistence.dao.iface.DAO;
import com.flipkart.flux.persistence.dao.iface.EventsDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAOV1;
import com.flipkart.flux.persistence.dao.iface.StateTraversalPathDAOV1;
import com.flipkart.flux.persistence.key.FSMId;
import com.flipkart.flux.utils.SearchUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.PersistenceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateMachineExecutionEntitiesManager
extends MultiEntityManager {
    private static final Logger LOGGER = LogManager.getLogger(StateMachineExecutionEntitiesManager.class);
    private final ObjectMapper objectMapper;
    private Integer maxRetryCount;
    private SearchUtil searchUtil;

    @Inject
    public StateMachineExecutionEntitiesManager(StateMachinesDAOV1 stateMachinesDAOV1, AuditDAOV1 auditDAOV1, StateTraversalPathDAOV1 stateTraversalPathDAOV1, EventsDAOV1 eventsDAOV1, @Named(value="task.maxTaskRetryCount") Integer maxRetryCount, SearchUtil searchUtil) {
        LinkedList<DAO> daos = new LinkedList<DAO>();
        daos.add(stateMachinesDAOV1);
        daos.add(auditDAOV1);
        daos.add(stateTraversalPathDAOV1);
        daos.add(eventsDAOV1);
        super.setDaos(daos);
        this.maxRetryCount = maxRetryCount;
        this.objectMapper = new ObjectMapper();
        this.searchUtil = searchUtil;
    }

    public StateMachine createStateMachine(FSMId fsmId, StateMachineDefinition stateMachineDefinition) {
        StateMachineExecutionEntitiesManager.validateReplayableStates(stateMachineDefinition);
        Map eventDataMap = stateMachineDefinition.getEventDataMap();
        Set<Event> allEvents = this.createAllEvents(eventDataMap);
        Set stateDefinitions = stateMachineDefinition.getStates();
        HashSet<State> states = new HashSet<State>();
        AtomicInteger stateId = new AtomicInteger(1);
        for (StateDefinition stateDefinition : stateDefinitions) {
            State state = this.convertStateDefinitionToState(stateDefinition, fsmId.statemachineId, stateId.longValue());
            states.add(state);
            stateId.incrementAndGet();
        }
        StateMachine stateMachine = new StateMachine(fsmId.statemachineId, stateMachineDefinition.getVersion(), stateMachineDefinition.getName(), stateMachineDefinition.getDescription(), states, stateMachineDefinition.getClientElbId());
        RAMContext context = new RAMContext(Long.valueOf(System.currentTimeMillis()), null, stateMachine);
        LinkedList<Object> createEntities = new LinkedList<Object>();
        createEntities.add(stateMachine);
        for (Event event : allEvents) {
            event.setStateMachineInstanceId(stateMachine.getId());
            createEntities.add(event);
        }
        for (State state : stateMachine.getStates()) {
            createEntities.add(new AuditRecord(stateMachine.getId(), state.getId(), Long.valueOf(0L), Status.initialized, null, null, Long.valueOf(0L), this.getDependentEvents(state.getDependencies(), 0L)));
        }
        HashMap<Long, List> replayStateTraversalPath = new HashMap<Long, List>();
        Set<Long> replayableStateIds = this.filterReplayableStates(stateMachine.getStates());
        for (Long replayableStateId : replayableStateIds) {
            List nextDependentStateIds = this.searchUtil.findStatesInTraversalPath((Context)context, stateMachine, replayableStateId);
            replayStateTraversalPath.put(replayableStateId, nextDependentStateIds);
            createEntities.add(new StateTraversalPath(stateMachine.getId(), replayableStateId, (List)replayStateTraversalPath.get(replayableStateId)));
        }
        this.create(createEntities.toArray(new Object[0]));
        return stateMachine;
    }

    public static StateMachineDefinition validateReplayableStates(StateMachineDefinition stateMachineDefinition) {
        Set setOfStates = stateMachineDefinition.getStates();
        HashMap<String, Integer> replayEventCount = new HashMap<String, Integer>();
        HashMap<String, Integer> replayableStates = new HashMap<String, Integer>();
        for (StateDefinition state : setOfStates) {
            if (!state.isReplayable() || state.getDependencies().isEmpty()) continue;
            replayableStates.putIfAbsent(state.getName(), 0);
            List dependentEvents = state.getDependencies();
            for (EventDefinition dependentEvent : dependentEvents) {
                if (dependentEvent.getEventSource() == null || !dependentEvent.getEventSource().toLowerCase().contains("flux_runtime_replay_internal".toLowerCase())) continue;
                replayableStates.put(state.getName(), (Integer)replayableStates.get(state.getName()) + 1);
                if (replayEventCount.get(dependentEvent.getName()) != null) {
                    replayEventCount.put(dependentEvent.getName(), (Integer)replayEventCount.get(dependentEvent.getName()) + 1);
                    continue;
                }
                replayEventCount.put(dependentEvent.getName(), 1);
            }
            if (replayableStates.get(state.getName()) == null || (Integer)replayableStates.get(state.getName()) <= 1) continue;
            LOGGER.error("There are 2 or more dependent replay events. To make state: {} as replayable, retry submitting workflow with only one dependent event as replayable.", (Object)state.getName(), (Object)state.getName());
            throw new PersistenceException("A single state cannot have multiple dependent replay events.");
        }
        if (!replayEventCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList()).isEmpty()) {
            throw new PersistenceException("Multiple states cannot have same Replay Event as dependency.");
        }
        return stateMachineDefinition;
    }

    private Set<Event> createAllEvents(Map<EventDefinition, EventData> eventDataMap) {
        HashSet<Event> allEvents = new HashSet<Event>();
        for (Map.Entry<EventDefinition, EventData> currentEventDefinitionAndData : eventDataMap.entrySet()) {
            Event currentEvent = this.convertEventDefinitionToEvent(currentEventDefinitionAndData.getKey());
            if (currentEventDefinitionAndData.getValue() != null) {
                currentEvent.setEventData(currentEventDefinitionAndData.getValue().getData());
                currentEvent.setEventSource(currentEventDefinitionAndData.getValue().getEventSource());
                currentEvent.setStatus(Event.EventStatus.triggered);
            }
            allEvents.add(currentEvent);
        }
        return allEvents;
    }

    private Event convertEventDefinitionToEvent(EventDefinition eventDefinition) {
        if (eventDefinition.getEventSource() != null) {
            return new Event(eventDefinition.getName(), eventDefinition.getType(), Event.EventStatus.pending, null, null, eventDefinition.getEventSource(), Long.valueOf(0L));
        }
        return new Event(eventDefinition.getName(), eventDefinition.getType(), Event.EventStatus.pending, null, null, null, Long.valueOf(0L));
    }

    private State convertStateDefinitionToState(StateDefinition stateDefinition, String stateMachineId, Long id) {
        try {
            List eventDefinitions = stateDefinition.getDependencies();
            LinkedList<String> events = new LinkedList<String>();
            if (eventDefinitions != null) {
                for (EventDefinition e : eventDefinitions) {
                    events.add(e.getName());
                }
            }
            if (stateDefinition.getMaxReplayableRetries() != null && stateDefinition.getMaxReplayableRetries() > PersistenceConstants.MAX_REPLAYABLE_RETRIES) {
                stateDefinition.setMaxReplayableRetries(PersistenceConstants.MAX_REPLAYABLE_RETRIES);
                LOGGER.warn("MaxReplayableRetries has been reset to {} for state {}. Value provided by user was higher than threshold", (Object)PersistenceConstants.MAX_REPLAYABLE_RETRIES, (Object)stateDefinition.getName());
            }
            State state = new State(stateDefinition.getVersion(), stateDefinition.getName(), stateDefinition.getDescription(), stateDefinition.getOnEntryHook(), stateDefinition.getTask(), stateDefinition.getOnExitHook(), events, Long.valueOf(Math.min(stateDefinition.getRetryCount(), (long)this.maxRetryCount.intValue())), stateDefinition.getTimeout(), stateDefinition.getOutputEvent() != null ? this.objectMapper.writeValueAsString((Object)stateDefinition.getOutputEvent()) : null, Status.initialized, null, Long.valueOf(0L), stateMachineId, id, Short.valueOf(stateDefinition.getMaxReplayableRetries() != null ? stateDefinition.getMaxReplayableRetries().shortValue() : PersistenceConstants.MAX_REPLAYABLE_RETRIES.shortValue()), Short.valueOf((short)0), Boolean.valueOf(stateDefinition.isReplayable()));
            return state;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to create state domain object", (Throwable)e);
        }
    }

    private String getDependentEvents(List<String> stateDependentEventNames, Long eventExecutionVersion) {
        LinkedList<AuditEvent> dependentEvents = new LinkedList<AuditEvent>();
        for (String dependentEventName : stateDependentEventNames) {
            dependentEvents.add(new AuditEvent(dependentEventName, eventExecutionVersion));
        }
        return ((Object)dependentEvents).toString();
    }

    private Set<Long> filterReplayableStates(Set<State> states) {
        HashSet<Long> replayableStateIds = new HashSet<Long>();
        for (State state : states) {
            if (!state.getReplayable().booleanValue()) continue;
            replayableStateIds.add(state.getId());
        }
        return replayableStateIds;
    }
}

