/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.DAO;
import com.flipkart.flux.shard.ShardedEntity;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import javax.transaction.Transactional;

public abstract class EntityManager<T> {
    private DAO<T> dao;

    @Inject
    public EntityManager(DAO<T> dao) {
        this.dao = dao;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public T create(T entity) {
        return this.dao.create(entity);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Object[] create(Object[] entities) {
        LinkedList<Object> persistedEntities = new LinkedList<Object>();
        ShardedEntity uniqueShard = null;
        for (Object entity : entities) {
            if (ShardedEntity.class.isAssignableFrom(entity.getClass())) {
                ShardedEntity newShard = (ShardedEntity)entity;
                if (uniqueShard == null) {
                    uniqueShard = newShard;
                } else if (!uniqueShard.equals(newShard)) {
                    throw new PersistenceException("Attempt to persist entities belonging to two different shards : " + uniqueShard.toString() + "," + newShard.toString());
                }
            }
            if (!entity.getClass().isAssignableFrom(this.dao.getPersistedEntityType())) continue;
            throw new PersistenceException("Unable to persist unsupported entity type : " + entity.getClass().getName());
        }
        for (Object entity : entities) {
            persistedEntities.add(this.dao.create(entity));
        }
        return persistedEntities.toArray(new Object[0]);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void update(T object) {
        this.dao.update(object);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public void remove(T entity) {
        this.dao.remove(entity);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public T findEntity(Object key) {
        return this.dao.findEntity(key);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_ONLY, storage=Storage.SHARDED)
    public T[] findEntitities(Object key) {
        return this.dao.findEntities(key);
    }

    protected DAO<T> getDAO() {
        return this.dao;
    }
}

