/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence;

import com.flipkart.flux.persistence.DataSourceType;
import com.flipkart.flux.persistence.PersistenceConstants;
import com.flipkart.flux.persistence.SelectDataSource;
import com.flipkart.flux.persistence.Storage;
import com.flipkart.flux.persistence.dao.iface.DAO;
import com.flipkart.flux.shard.ShardedEntity;
import com.flipkart.flux.utils.Pair;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.transaction.Transactional;

public abstract class MultiEntityManager {
    private List<DAO> daos;

    public List<DAO> getDaos() {
        return this.daos;
    }

    public void setDaos(List<DAO> daos) {
        this.daos = daos;
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Object[] create(Object[] entities) {
        this.checkPersistenceContraints(entities);
        return this.createEntities(entities);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Object[] update(Object[] entities) {
        this.checkPersistenceContraints(entities);
        return this.updateEntities(entities);
    }

    @Transactional
    @SelectDataSource(type=DataSourceType.READ_WRITE, storage=Storage.SHARDED)
    public Pair<PersistenceConstants.Operation, Object[]>[] createAndUpdate(Object[] createEntities, Object[] updateEntities) {
        Object[] allInputEntities = new Object[createEntities.length + updateEntities.length];
        System.arraycopy(createEntities, 0, allInputEntities, 0, createEntities.length);
        System.arraycopy(updateEntities, 0, allInputEntities, createEntities.length, updateEntities.length);
        this.checkPersistenceContraints(allInputEntities);
        Pair[] results = new Pair[]{new Pair((Object)PersistenceConstants.Operation.Create, (Object)this.createEntities(createEntities)), new Pair((Object)PersistenceConstants.Operation.Update, (Object)this.updateEntities(updateEntities))};
        return results;
    }

    private Object[] createEntities(Object[] entities) {
        LinkedList<Object> persistedEntities = new LinkedList<Object>();
        for (Object entity : entities) {
            persistedEntities.add(this.daos.stream().filter(dao -> entity.getClass().isAssignableFrom(dao.getPersistedEntityType())).findFirst().get().create(entity));
        }
        return persistedEntities.toArray(new Object[0]);
    }

    private Object[] updateEntities(Object[] entities) {
        LinkedList<Object> persistedEntities = new LinkedList<Object>();
        for (Object entity : entities) {
            this.daos.stream().filter(dao -> entity.getClass().isAssignableFrom(dao.getPersistedEntityType())).findFirst().get().update(entity);
            persistedEntities.add(entity);
        }
        return persistedEntities.toArray(new Object[0]);
    }

    private void checkPersistenceContraints(Object[] entities) {
        ShardedEntity uniqueShard = null;
        for (Object entity : entities) {
            if (ShardedEntity.class.isAssignableFrom(entity.getClass())) {
                ShardedEntity newShard = (ShardedEntity)entity;
                if (uniqueShard == null) {
                    uniqueShard = newShard;
                } else if (!uniqueShard.equals(newShard)) {
                    throw new PersistenceException("Attempt to persist entities belonging to two different shards : " + uniqueShard.toString() + "," + newShard.toString());
                }
            }
            if (this.daos.stream().anyMatch(dao -> entity.getClass().isAssignableFrom(dao.getPersistedEntityType()))) continue;
            throw new PersistenceException("Unable to persist unsupported entity type : " + entity.getClass().getName());
        }
    }
}

