/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.domain.StateMachine;
import com.flipkart.flux.persistence.SessionFactoryContext;
import com.flipkart.flux.persistence.criteria.FSMNameCriteria;
import com.flipkart.flux.persistence.dao.iface.StateMachinesDAOV1;
import com.flipkart.flux.persistence.dao.impl.AbstractDAO;
import com.flipkart.flux.persistence.dto.StateMachineUpdate;
import com.flipkart.flux.persistence.key.FSMId;
import com.google.inject.name.Named;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class StateMachinesDAOV1Impl
extends AbstractDAO<StateMachine>
implements StateMachinesDAOV1 {
    @Inject
    public StateMachinesDAOV1Impl(@Named(value="fluxSessionFactoriesContext") SessionFactoryContext sessionFactoryContext) {
        super(sessionFactoryContext);
    }

    public StateMachine create(StateMachine entity) {
        return super.save(entity);
    }

    @Override
    public void update(StateMachine object) {
        super.update(object);
    }

    public void remove(StateMachine entity) {
        throw new PersistenceException("Operation is not supported!");
    }

    public StateMachine findEntity(Object key) {
        if (key instanceof FSMId) {
            return (StateMachine)super.findById(StateMachine.class, ((FSMId)key).statemachineId);
        }
        throw new PersistenceException("Find StateMachine is not supported for : " + key);
    }

    public StateMachine[] findEntities(Object key) {
        if (key instanceof FSMNameCriteria) {
            return this.findByFSMName((FSMNameCriteria)key);
        }
        throw new PersistenceException("Find StateMachineS is not supported for key : " + key);
    }

    public void updateStateMachine(StateMachineUpdate.Field field, Object updates) {
        switch (field) {
            case status: {
                if (!(updates instanceof StateMachineUpdate.StatusUpdate)) break;
                this.updateStatus((StateMachineUpdate.StatusUpdate)updates);
                return;
            }
            case executionVersion: {
                if (!(updates instanceof StateMachineUpdate.ExecutionVersionUpdate)) break;
                this.updateExecutionVersion((StateMachineUpdate.ExecutionVersionUpdate)updates);
                return;
            }
            default: {
                throw new PersistenceException("Unable to update StateMachine using unsupported Field type : " + field);
            }
        }
        throw new PersistenceException("Unable to update StateMachine using unsupported update object type : " + updates);
    }

    public long getExecutionVersionForUpdate(FSMId fsmId) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(StateMachine.class);
        Root root = cq.from(StateMachine.class);
        Predicate[] restrictions = new Predicate[]{cb.equal((Expression)root.get("id"), (Object)fsmId.statemachineId)};
        cq.select((Selection)root).where(restrictions);
        return ((StateMachine)this.currentSession().createQuery(cq).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult()).getExecutionVersion();
    }

    private StateMachine[] findByFSMName(FSMNameCriteria nameCriteria) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(StateMachine.class);
        Root root = cq.from(StateMachine.class);
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        predicateList.add(cb.equal((Expression)root.get("name"), (Object)nameCriteria.fsmName));
        if (nameCriteria.version != null) {
            predicateList.add(cb.equal((Expression)root.get("version"), (Object)nameCriteria.version));
        }
        cq.select((Selection)root).where(predicateList.toArray(new Predicate[0]));
        return this.currentSession().createQuery(cq).getResultList().toArray(new StateMachine[0]);
    }

    private void updateStatus(StateMachineUpdate.StatusUpdate statusUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(StateMachine.class);
        Root root = cu.from(StateMachine.class);
        cu.set("status", (Object)statusUpdate.status);
        cu.where((Expression)cb.equal((Expression)root.get("id"), (Object)statusUpdate.fsmId.statemachineId));
        this.currentSession().createQuery(cu).executeUpdate();
    }

    private void updateExecutionVersion(StateMachineUpdate.ExecutionVersionUpdate versionUpdate) {
        CriteriaBuilder cb = this.currentSession().getCriteriaBuilder();
        CriteriaUpdate cu = cb.createCriteriaUpdate(StateMachine.class);
        Root root = cu.from(StateMachine.class);
        cu.set("executionVersion", (Object)versionUpdate.version);
        cu.where((Expression)cb.equal((Expression)root.get("id"), (Object)versionUpdate.fsmId.statemachineId));
        this.currentSession().createQuery(cu).executeUpdate();
    }
}

