/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.persistence.dao.impl;

import com.flipkart.flux.persistence.SessionFactoryContext;
import java.lang.reflect.ParameterizedType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractDAO<T> {
    private SessionFactoryContext sessionFactoryContext;

    public AbstractDAO(SessionFactoryContext sessionFactoryContext) {
        this.sessionFactoryContext = sessionFactoryContext;
    }

    public Session currentSession() {
        return this.sessionFactoryContext.getThreadLocalSession();
    }

    public T findById(Class cls, Long id) {
        Criteria criteria = this.currentSession().createCriteria(cls).add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Object object = criteria.uniqueResult();
        Object castedObject = null;
        if (object != null) {
            castedObject = object;
        }
        return (T)castedObject;
    }

    public T findById(Class cls, String id) {
        Criteria criteria = this.currentSession().createCriteria(cls).add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Object object = criteria.uniqueResult();
        Object castedObject = null;
        if (object != null) {
            castedObject = object;
        }
        return (T)castedObject;
    }

    public T findByCompositeIdFromStateTable(Class cls, String smId, Long id) {
        Criteria criteria = this.currentSession().createCriteria(cls).add((Criterion)Restrictions.eq((String)"stateMachineId", (Object)smId)).add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Object object = criteria.uniqueResult();
        Object castedObject = null;
        if (object != null) {
            castedObject = object;
        }
        return (T)castedObject;
    }

    public T save(T object) {
        this.currentSession().save(object);
        return object;
    }

    public void update(T object) {
        this.currentSession().update(object);
    }

    public T saveOrUpdate(T object) {
        this.currentSession().saveOrUpdate(object);
        return object;
    }

    public void delete(T object) {
        this.currentSession().delete(object);
    }

    public Class getPersistedEntityType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

